/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui.internal;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MethodSearchPattern {
    private MethodSearchPattern() {
    }

    public static Pattern createPattern(String pattern, boolean isCaseSensitive, boolean isRegexSearch) throws PatternSyntaxException {
        if (!isRegexSearch) {
            pattern = MethodSearchPattern.toRegexPattern(pattern);
        }
        if (!isCaseSensitive) {
            return Pattern.compile(pattern, 74);
        }
        return Pattern.compile(pattern, 8);
    }

    private static String toRegexPattern(String pattern) {
        int patternLength = pattern.length();
        StringBuffer result = new StringBuffer(patternLength);
        boolean escaped = false;
        boolean quoting = false;
        int i = 0;
        while (i < patternLength) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '*': {
                    if (!escaped && quoting) {
                        result.append("\\E");
                        quoting = false;
                    }
                    result.append(".*");
                    escaped = false;
                    break;
                }
                case '?': {
                    if (!escaped && quoting) {
                        result.append("\\E");
                        quoting = false;
                    }
                    result.append(".");
                    escaped = false;
                    break;
                }
                case '\\': {
                    if (!escaped) {
                        escaped = true;
                        break;
                    }
                    escaped = false;
                    if (quoting) {
                        result.append("\\E");
                        quoting = false;
                    }
                    result.append("\\\\");
                    break;
                }
                default: {
                    if (!quoting) {
                        result.append("\\Q");
                        quoting = true;
                    }
                    if (escaped && ch != '*' && ch != '?' && ch != '\\') {
                        result.append('\\');
                    }
                    result.append(ch);
                    escaped = ch == '\\';
                }
            }
            ++i;
        }
        if (quoting) {
            result.append("\\E");
        }
        return result.toString();
    }
}

