/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.search.ui.SearchUIResources;
import org.eclipse.epf.search.ui.internal.IMethodSearchOperation;
import org.eclipse.epf.search.ui.internal.ISearchResultCollector;
import org.eclipse.epf.search.ui.internal.MethodSearchHelper;
import org.eclipse.epf.search.ui.internal.MethodSearchInput;
import org.eclipse.epf.search.ui.internal.MethodSearchResult;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class MethodSearchQuery
implements ISearchQuery {
    private MethodSearchInput searchInput;
    private MethodSearchResult searchResult;

    public MethodSearchQuery(MethodSearchInput searchInput) {
        this.searchInput = searchInput;
    }

    public IStatus run(IProgressMonitor processMonitor) {
        final MethodSearchResult searchResult = (MethodSearchResult)this.getSearchResult();
        searchResult.removeAll();
        ISearchResultCollector result = new ISearchResultCollector(){

            public void accept(Object match) {
                Match[] matches;
                if (match instanceof MethodElement && !TngUtil.isPredefined((MethodElement)((MethodElement)match)) && ((matches = searchResult.getMatches(match)) == null || matches.length == 0)) {
                    searchResult.addMatch(new Match(match, 1, 1, 1));
                }
            }
        };
        IMethodSearchOperation op = MethodSearchHelper.newSearchOperation();
        op.execute(this.searchInput, result, processMonitor);
        processMonitor.done();
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return SearchUIResources.searchQuery_text;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.searchResult == null) {
            this.searchResult = new MethodSearchResult(this);
        }
        return this.searchResult;
    }

    public MethodSearchInput getSearchInput() {
        return this.searchInput;
    }
}

