/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSearchScope {
    public static final String ROOT = "Root";
    public static final String METHOD_CONTENT = LibraryUIText.TEXT_METHOD_CONTENT;
    public static final String ROLE = LibraryUIText.TEXT_ROLE;
    public static final String TASK = LibraryUIText.TEXT_TASK;
    public static final String WORK_PRODUCT = LibraryUIText.TEXT_WORK_PRODUCT;
    public static final String GUIDANCE = LibraryUIText.TEXT_GUIDANCE;
    public static final String UDT = LibraryUIText.TEXT_UDT;
    public static final String CHECKLIST = LibraryUIText.TEXT_CHECKLIST;
    public static final String CONCEPT = LibraryUIText.TEXT_CONCEPT;
    public static final String ESTIMATION_CONSIDERATIONS = LibraryUIText.TEXT_ESTIMATION_CONSIDERATIONS;
    public static final String EXAMPLE = LibraryUIText.TEXT_EXAMPLE;
    public static final String GUIDELINE = LibraryUIText.TEXT_GUIDELINE;
    public static final String PRACTICE = LibraryUIText.TEXT_PRACTICE;
    public static final String REPORT = LibraryUIText.TEXT_REPORT;
    public static final String REUSABLE_ASSET = LibraryUIText.TEXT_REUSABLE_ASSET;
    public static final String ROADMAP = LibraryUIText.TEXT_ROADMAP;
    public static final String SUPPORTING_MATERIAL = LibraryUIText.TEXT_SUPPORTING_MATERIAL;
    public static final String TEMPLATE = LibraryUIText.TEXT_TEMPLATE;
    public static final String TERM_DEFINITION = LibraryUIText.TEXT_TERM_DEFINITION;
    public static final String TOOL_MENTOR = LibraryUIText.TEXT_TOOL_MENTOR;
    public static final String WHITEPAPER = LibraryUIText.TEXT_WHITEPAPER;
    public static final String STANDARD_CATEGORY = LibraryUIText.TEXT_STANDARD_CATEGORY;
    public static final String CUSTOM_CATEGORY = LibraryUIText.TEXT_CUSTOM_CATEGORY;
    public static final String PROCESS = LibraryUIText.TEXT_PROCESS;
    public static final String CAPABILITY_PATTERN = LibraryUIText.TEXT_CAPABILITY_PATTERN;
    public static final String DELIVERY_PROCESS = LibraryUIText.TEXT_DELIVERY_PROCESS;
    public static final Map<EClass, String> elementSearchScope = new HashMap<EClass, String>();
    private static final Map<String, Collection<EClass>> scopeToEClassesMap = new HashMap<String, Collection<EClass>>();
    public static EClass UDTeClass = EcoreFactory.eINSTANCE.createEClass();
    public static final MethodSearchScope INCLUDE_ALL_SEARCH_SCOPE;
    private List<Object> searchScope = new ArrayList<Object>();
    private ArrayList<EClass> selectedTypes;

    static {
        elementSearchScope.put(UDTeClass, UDT);
        elementSearchScope.put(UmaPackage.eINSTANCE.getMethodPlugin(), ROOT);
        elementSearchScope.put(UmaPackage.eINSTANCE.getContentPackage(), METHOD_CONTENT);
        elementSearchScope.put(UmaPackage.eINSTANCE.getRole(), ROLE);
        elementSearchScope.put(UmaPackage.eINSTANCE.getTask(), TASK);
        elementSearchScope.put(UmaPackage.eINSTANCE.getArtifact(), WORK_PRODUCT);
        elementSearchScope.put(UmaPackage.eINSTANCE.getDeliverable(), WORK_PRODUCT);
        elementSearchScope.put(UmaPackage.eINSTANCE.getOutcome(), WORK_PRODUCT);
        elementSearchScope.put(UmaPackage.eINSTANCE.getGuidance(), GUIDANCE);
        elementSearchScope.put(UmaPackage.eINSTANCE.getChecklist(), CHECKLIST);
        elementSearchScope.put(UmaPackage.eINSTANCE.getConcept(), CONCEPT);
        elementSearchScope.put(UmaPackage.eINSTANCE.getEstimationConsiderations(), ESTIMATION_CONSIDERATIONS);
        elementSearchScope.put(UmaPackage.eINSTANCE.getExample(), EXAMPLE);
        elementSearchScope.put(UmaPackage.eINSTANCE.getGuideline(), GUIDELINE);
        elementSearchScope.put(UmaPackage.eINSTANCE.getPractice(), PRACTICE);
        elementSearchScope.put(UmaPackage.eINSTANCE.getReport(), REPORT);
        elementSearchScope.put(UmaPackage.eINSTANCE.getReusableAsset(), REUSABLE_ASSET);
        elementSearchScope.put(UmaPackage.eINSTANCE.getRoadmap(), ROADMAP);
        elementSearchScope.put(UmaPackage.eINSTANCE.getSupportingMaterial(), SUPPORTING_MATERIAL);
        elementSearchScope.put(UmaPackage.eINSTANCE.getTemplate(), TEMPLATE);
        elementSearchScope.put(UmaPackage.eINSTANCE.getTermDefinition(), TERM_DEFINITION);
        elementSearchScope.put(UmaPackage.eINSTANCE.getToolMentor(), TOOL_MENTOR);
        elementSearchScope.put(UmaPackage.eINSTANCE.getWhitepaper(), WHITEPAPER);
        elementSearchScope.put(UmaPackage.eINSTANCE.getContentCategory(), STANDARD_CATEGORY);
        elementSearchScope.put(UmaPackage.eINSTANCE.getDiscipline(), STANDARD_CATEGORY);
        elementSearchScope.put(UmaPackage.eINSTANCE.getDisciplineGrouping(), STANDARD_CATEGORY);
        elementSearchScope.put(UmaPackage.eINSTANCE.getDomain(), STANDARD_CATEGORY);
        elementSearchScope.put(UmaPackage.eINSTANCE.getWorkProductType(), STANDARD_CATEGORY);
        elementSearchScope.put(UmaPackage.eINSTANCE.getRoleSet(), STANDARD_CATEGORY);
        elementSearchScope.put(UmaPackage.eINSTANCE.getRoleSetGrouping(), STANDARD_CATEGORY);
        elementSearchScope.put(UmaPackage.eINSTANCE.getTool(), STANDARD_CATEGORY);
        elementSearchScope.put(UmaPackage.eINSTANCE.getCustomCategory(), CUSTOM_CATEGORY);
        elementSearchScope.put(UmaPackage.eINSTANCE.getProcessPackage(), PROCESS);
        elementSearchScope.put(UmaPackage.eINSTANCE.getProcessComponent(), PROCESS);
        elementSearchScope.put(UmaPackage.eINSTANCE.getPhase(), PROCESS);
        elementSearchScope.put(UmaPackage.eINSTANCE.getIteration(), PROCESS);
        elementSearchScope.put(UmaPackage.eINSTANCE.getMilestone(), PROCESS);
        elementSearchScope.put(UmaPackage.eINSTANCE.getActivity(), PROCESS);
        elementSearchScope.put(UmaPackage.eINSTANCE.getRoleDescriptor(), PROCESS);
        elementSearchScope.put(UmaPackage.eINSTANCE.getTaskDescriptor(), PROCESS);
        elementSearchScope.put(UmaPackage.eINSTANCE.getWorkProductDescriptor(), PROCESS);
        elementSearchScope.put(UmaPackage.eINSTANCE.getCapabilityPattern(), CAPABILITY_PATTERN);
        elementSearchScope.put(UmaPackage.eINSTANCE.getDeliveryProcess(), DELIVERY_PROCESS);
        scopeToEClassesMap.put(ROLE, Collections.singleton(UmaPackage.eINSTANCE.getRole()));
        scopeToEClassesMap.put(TASK, Collections.singleton(UmaPackage.eINSTANCE.getTask()));
        scopeToEClassesMap.put(WORK_PRODUCT, Arrays.asList(UmaPackage.eINSTANCE.getArtifact(), UmaPackage.eINSTANCE.getDeliverable(), UmaPackage.eINSTANCE.getOutcome()));
        scopeToEClassesMap.put(CHECKLIST, Collections.singleton(UmaPackage.eINSTANCE.getChecklist()));
        scopeToEClassesMap.put(CONCEPT, Collections.singleton(UmaPackage.eINSTANCE.getConcept()));
        scopeToEClassesMap.put(ESTIMATION_CONSIDERATIONS, Collections.singleton(UmaPackage.eINSTANCE.getEstimationConsiderations()));
        scopeToEClassesMap.put(EXAMPLE, Collections.singleton(UmaPackage.eINSTANCE.getEstimationConsiderations()));
        scopeToEClassesMap.put(GUIDELINE, Collections.singleton(UmaPackage.eINSTANCE.getGuideline()));
        scopeToEClassesMap.put(PRACTICE, Collections.singleton(UmaPackage.eINSTANCE.getPractice()));
        scopeToEClassesMap.put(REPORT, Collections.singleton(UmaPackage.eINSTANCE.getReport()));
        scopeToEClassesMap.put(REUSABLE_ASSET, Collections.singleton(UmaPackage.eINSTANCE.getReusableAsset()));
        scopeToEClassesMap.put(ROADMAP, Collections.singleton(UmaPackage.eINSTANCE.getRoadmap()));
        scopeToEClassesMap.put(SUPPORTING_MATERIAL, Collections.singleton(UmaPackage.eINSTANCE.getSupportingMaterial()));
        scopeToEClassesMap.put(TEMPLATE, Collections.singleton(UmaPackage.eINSTANCE.getTemplate()));
        scopeToEClassesMap.put(TERM_DEFINITION, Collections.singleton(UmaPackage.eINSTANCE.getTermDefinition()));
        scopeToEClassesMap.put(TOOL_MENTOR, Collections.singleton(UmaPackage.eINSTANCE.getToolMentor()));
        scopeToEClassesMap.put(WHITEPAPER, Collections.singleton(UmaPackage.eINSTANCE.getWhitepaper()));
        scopeToEClassesMap.put(STANDARD_CATEGORY, Arrays.asList(UmaPackage.eINSTANCE.getDiscipline(), UmaPackage.eINSTANCE.getDisciplineGrouping(), UmaPackage.eINSTANCE.getDomain(), UmaPackage.eINSTANCE.getWorkProductType(), UmaPackage.eINSTANCE.getRoleSet(), UmaPackage.eINSTANCE.getRoleSetGrouping(), UmaPackage.eINSTANCE.getTool()));
        scopeToEClassesMap.put(CUSTOM_CATEGORY, Collections.singleton(UmaPackage.eINSTANCE.getCustomCategory()));
        scopeToEClassesMap.put(CAPABILITY_PATTERN, Collections.singleton(UmaPackage.eINSTANCE.getCapabilityPattern()));
        scopeToEClassesMap.put(DELIVERY_PROCESS, Collections.singleton(UmaPackage.eINSTANCE.getDeliveryProcess()));
        INCLUDE_ALL_SEARCH_SCOPE = new MethodSearchScope(scopeToEClassesMap.keySet().toArray());
    }

    public MethodSearchScope(Object[] elementTypes) {
        this(elementTypes, true);
    }

    public MethodSearchScope(Object[] elementTypes, boolean includeRoot) {
        if (includeRoot) {
            this.searchScope.add(ROOT);
        }
        int i = 0;
        while (i < elementTypes.length) {
            Object elementType = elementTypes[i];
            this.searchScope.add(elementType);
            ++i;
        }
    }

    public boolean includeCoreContent() {
        return this.searchScope.contains(ROLE) || this.searchScope.contains(TASK) || this.searchScope.contains(WORK_PRODUCT) || this.searchScope.contains(GUIDANCE) || this.searchScope.contains(UDT) || this.searchScope.contains(CHECKLIST) || this.searchScope.contains(CONCEPT) || this.searchScope.contains(ESTIMATION_CONSIDERATIONS) || this.searchScope.contains(EXAMPLE) || this.searchScope.contains(GUIDELINE) || this.searchScope.contains(PRACTICE) || this.searchScope.contains(REPORT) || this.searchScope.contains(REUSABLE_ASSET) || this.searchScope.contains(ROADMAP) || this.searchScope.contains(SUPPORTING_MATERIAL) || this.searchScope.contains(TEMPLATE) || this.searchScope.contains(TERM_DEFINITION) || this.searchScope.contains(TOOL_MENTOR) || this.searchScope.contains(WHITEPAPER);
    }

    public boolean include(MethodElement element) {
        if (element == null) {
            return false;
        }
        String searchScopeName = elementSearchScope.get(element.eClass());
        if (PracticePropUtil.getPracticePropUtil().isUdtType(element)) {
            searchScopeName = UDT;
        }
        return this.searchScope.contains(searchScopeName);
    }

    public boolean include(String searchScopeName) {
        return this.searchScope.contains(searchScopeName);
    }

    public Collection<EClass> getSelectedTypes() {
        if (this.selectedTypes == null) {
            this.selectedTypes = new ArrayList();
            for (Map.Entry<String, Collection<EClass>> entry : scopeToEClassesMap.entrySet()) {
                if (!this.searchScope.contains(entry.getKey())) continue;
                this.selectedTypes.addAll(entry.getValue());
            }
        }
        return this.selectedTypes;
    }

    public static String getTypeText(String typeName) {
        EClassifier cls = UmaPackage.eINSTANCE.getEClassifier(typeName);
        if (typeName.equals(UDT)) {
            return UDT;
        }
        return elementSearchScope.get(cls);
    }

    public String toString() {
        if (this.searchScope == null && this.searchScope.isEmpty()) {
            return "";
        }
        StringBuffer strBuffer = new StringBuffer();
        int max = this.searchScope.size() - 1;
        int i = 0;
        while (i < max) {
            strBuffer.append(this.searchScope.get(i)).append(',');
            ++i;
        }
        return strBuffer.append(this.searchScope.get(max)).toString();
    }
}

