/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.analysis;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.Attribute;
import org.eclipse.epf.common.utils.StrUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextFilter
extends TokenFilter {
    private static Set stopWords = null;

    public TextFilter(TokenStream in) {
        super(in);
        if (stopWords == null) {
            this.loadStopWords();
        }
    }

    public final Class<? extends Attribute> next() throws IOException {
        Class token = (Class)this.input.getAttributeClassesIterator().next();
        while (token != null) {
            String tokenText = token.getName();
            if (!stopWords.contains(tokenText)) {
                return token;
            }
            token = (Class)this.input.getAttributeClassesIterator().next();
        }
        return null;
    }

    private void loadStopWords() {
        String[] words = null;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(TextFilter.class.getPackage().getName()) + ".StopWords");
            String property = bundle.getString("Search.stopWords");
            words = StrUtil.split((String)property, (String)" ,");
        }
        catch (Exception exception) {
            Set stopWords = StopAnalyzer.ENGLISH_STOP_WORDS_SET;
            words = stopWords.toArray(new String[stopWords.size()]);
        }
        stopWords = StopFilter.makeStopSet((String[])words);
    }

    public boolean incrementToken() throws IOException {
        return false;
    }
}

