/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma.ecore.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.ecore.util.OppositeFeatureResolvingEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOppositeFeatureManager {
    protected Map<Class<?>, Set<OppositeFeature>> classOppositeFeaturesMap = new HashMap();
    protected Map<EStructuralFeature, OppositeFeature> featureOppositeFeatureMap = new HashMap<EStructuralFeature, OppositeFeature>();
    private ArrayList<OppositeFeature> predefinedOppositeFeatures;

    public OppositeFeature getOppositeFeature(EStructuralFeature feature) {
        return this.featureOppositeFeatureMap.get(feature);
    }

    public void registerOppositeFeature(OppositeFeature oppositeFeature) {
        Class cls = oppositeFeature.getOwnerClass();
        Set<OppositeFeature> features = this.classOppositeFeaturesMap.get(cls);
        if (features == null) {
            features = new HashSet<OppositeFeature>();
            this.classOppositeFeaturesMap.put(cls, features);
        }
        features.add(oppositeFeature);
        this.featureOppositeFeatureMap.put(oppositeFeature.getTargetFeature(), oppositeFeature);
    }

    protected AbstractOppositeFeatureManager() {
        this.registerPredefinedOppositeFeatures();
    }

    private void registerPredefinedOppositeFeatures() {
        this.predefinedOppositeFeatures = new ArrayList();
        Field[] fields = this.getClass().getFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            int mod = field.getModifiers();
            if (Modifier.isPublic(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod) && field.getType() == OppositeFeature.class) {
                try {
                    this.predefinedOppositeFeatures.add((OppositeFeature)field.get(this));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        for (OppositeFeature feature : this.predefinedOppositeFeatures) {
            this.registerOppositeFeature(feature);
        }
    }

    public Collection<OppositeFeature> getPredefinedOppositeFeatures() {
        return this.predefinedOppositeFeatures;
    }

    public Object getOppositeFeatureValue(EObject eObject, OppositeFeature feature) {
        OppositeFeatureAdapter adapter = this.getOppositeFeatureAdapter(eObject);
        if (adapter == null) {
            throw new IllegalArgumentException("Object is not managed by this manager.");
        }
        return adapter.getOppositeFeatureValue(feature);
    }

    public Collection<OppositeFeature> getOppositeFeatures(EObject eObject) {
        OppositeFeatureAdapter adapter = this.getOppositeFeatureAdapter(eObject);
        if (adapter == null) {
            throw new IllegalArgumentException("Object is not managed by this manager.");
        }
        return adapter.getOppositeFeatures();
    }

    public void manage(EObject eObject) {
        OppositeFeatureAdapter adapter = this.getOppositeFeatureAdapter(eObject);
        if (adapter == null) {
            adapter = this.createOppositeFeatureAdapter();
            eObject.eAdapters().add((Object)adapter);
        }
    }

    protected OppositeFeatureAdapter createOppositeFeatureAdapter() {
        return new OppositeFeatureAdapter();
    }

    public void release(EObject eObject) {
        OppositeFeatureAdapter adapter = this.getOppositeFeatureAdapter(eObject);
        if (adapter != null) {
            eObject.eAdapters().remove((Object)adapter);
        }
    }

    private OppositeFeatureAdapter getOppositeFeatureAdapter(EObject eObject) {
        for (Adapter adapter : new ArrayList(eObject.eAdapters())) {
            if (!(adapter instanceof OppositeFeatureAdapter)) continue;
            return (OppositeFeatureAdapter)adapter;
        }
        return null;
    }

    public void removeFromAllOppositeFeatures(EObject eObject) {
        for (EReference ref : eObject.eClass().getEAllReferences()) {
            OppositeFeature oppositeFeature = OppositeFeature.getOppositeFeature((EStructuralFeature)ref);
            if (oppositeFeature == null) continue;
            if (ref.isMany()) {
                List list = (List)eObject.eGet((EStructuralFeature)ref, false);
                if (list.isEmpty()) continue;
                if (!oppositeFeature.resolveOwner()) {
                    list.clear();
                    continue;
                }
                if (!(list instanceof InternalEList)) continue;
                List basicList = ((InternalEList)list).basicList();
                int i = basicList.size() - 1;
                while (i > -1) {
                    EObject e = (EObject)basicList.get(i);
                    if (!e.eIsProxy()) {
                        list.remove(e);
                    }
                    --i;
                }
                continue;
            }
            EObject e = (EObject)eObject.eGet((EStructuralFeature)ref, false);
            if (e == null || e.eIsProxy()) continue;
            eObject.eSet((EStructuralFeature)ref, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OppositeFeatureAdapter
    extends AdapterImpl {
        private static final boolean DEBUG = false;
        private Map<OppositeFeature, Object> oppositeFeatureMap;
        private boolean hasOppositeFeature = true;

        protected OppositeFeatureAdapter() {
        }

        public void notifyChanged(Notification msg) {
            block36: {
                EStructuralFeature feature;
                OppositeFeature oppositeFeature;
                Object f;
                block37: {
                    if (msg.getEventType() == 9) {
                        return;
                    }
                    f = msg.getFeature();
                    if (!(f instanceof EStructuralFeature) || (oppositeFeature = AbstractOppositeFeatureManager.this.getOppositeFeature(feature = (EStructuralFeature)f)) == null) break block36;
                    if (!oppositeFeature.isMany()) break block37;
                    switch (msg.getEventType()) {
                        case 1: {
                            OppositeFeatureAdapter adapter;
                            EObject oldOtherEnd = (EObject)msg.getOldValue();
                            if (oppositeFeature.resolveOwner()) {
                                oldOtherEnd = (EObject)this.resolve(oldOtherEnd);
                            }
                            if (oldOtherEnd != null) {
                                adapter = AbstractOppositeFeatureManager.this.getOppositeFeatureAdapter(oldOtherEnd);
                                adapter.oppositeRemove(oppositeFeature, msg.getNotifier());
                            }
                        }
                        case 3: {
                            OppositeFeatureAdapter adapter;
                            EObject otherEnd = (EObject)msg.getNewValue();
                            if (oppositeFeature.resolveOwner()) {
                                otherEnd = (EObject)this.resolve(otherEnd);
                                this.replace(feature, msg.getNewValue(), otherEnd);
                            }
                            if (otherEnd != null) {
                                adapter = AbstractOppositeFeatureManager.this.getOppositeFeatureAdapter(otherEnd);
                                adapter.oppositeAdd(oppositeFeature, msg.getNotifier());
                                break;
                            }
                            break block36;
                        }
                        case 5: {
                            for (Object obj : (Collection)msg.getNewValue()) {
                                EObject otherEnd = (EObject)obj;
                                if (oppositeFeature.resolveOwner()) {
                                    otherEnd = (EObject)this.resolve(otherEnd);
                                    this.replace(feature, obj, otherEnd);
                                }
                                OppositeFeatureAdapter adapter = AbstractOppositeFeatureManager.this.getOppositeFeatureAdapter(otherEnd);
                                adapter.oppositeAdd(oppositeFeature, msg.getNotifier());
                            }
                            break block36;
                        }
                        case 4: {
                            EObject otherEnd = (EObject)msg.getOldValue();
                            if (oppositeFeature.resolveOwner()) {
                                otherEnd = (EObject)this.resolve(otherEnd);
                            }
                            if (otherEnd != null) {
                                OppositeFeatureAdapter adapter = AbstractOppositeFeatureManager.this.getOppositeFeatureAdapter(otherEnd);
                                adapter.oppositeRemove(oppositeFeature, msg.getNotifier());
                                break;
                            }
                            break block36;
                        }
                        case 6: {
                            for (EObject otherEnd : (Collection)msg.getOldValue()) {
                                if (oppositeFeature.resolveOwner()) {
                                    otherEnd = (EObject)this.resolve(otherEnd);
                                }
                                OppositeFeatureAdapter adapter = AbstractOppositeFeatureManager.this.getOppositeFeatureAdapter(otherEnd);
                                adapter.oppositeRemove(oppositeFeature, msg.getNotifier());
                            }
                        }
                    }
                    break block36;
                }
                switch (msg.getEventType()) {
                    case 5: {
                        for (Object obj : (Collection)msg.getNewValue()) {
                            EObject otherEnd = (EObject)obj;
                            if (oppositeFeature.resolveOwner()) {
                                otherEnd = (EObject)this.resolve(otherEnd);
                                this.replace(feature, obj, otherEnd);
                            }
                            if (otherEnd == null) continue;
                            OppositeFeatureAdapter adapter = AbstractOppositeFeatureManager.this.getOppositeFeatureAdapter(otherEnd);
                            EObject oldValue = (EObject)adapter.getOppositeFeatureMap().get(oppositeFeature);
                            if (oldValue != null) {
                                ((Collection)oldValue.eGet((EStructuralFeature)f)).remove(otherEnd);
                            }
                            adapter.getOppositeFeatureMap().put(oppositeFeature, msg.getNotifier());
                        }
                        break;
                    }
                    case 6: {
                        for (EObject otherEnd : (Collection)msg.getOldValue()) {
                            if (oppositeFeature.resolveOwner()) {
                                otherEnd = (EObject)this.resolve(otherEnd);
                            }
                            OppositeFeatureAdapter adapter = AbstractOppositeFeatureManager.this.getOppositeFeatureAdapter(otherEnd);
                            adapter.getOppositeFeatureMap().put(oppositeFeature, null);
                        }
                        break;
                    }
                    case 3: {
                        EObject otherEnd = (EObject)msg.getNewValue();
                        if (oppositeFeature.resolveOwner()) {
                            otherEnd = (EObject)this.resolve(otherEnd);
                            this.replace(feature, msg.getNewValue(), otherEnd);
                        }
                        if (otherEnd == null) break;
                        OppositeFeatureAdapter adapter = AbstractOppositeFeatureManager.this.getOppositeFeatureAdapter(otherEnd);
                        EObject oldValue = (EObject)adapter.getOppositeFeatureMap().get(oppositeFeature);
                        if (oldValue != null) {
                            ((Collection)oldValue.eGet((EStructuralFeature)f)).remove(otherEnd);
                        }
                        adapter.getOppositeFeatureMap().put(oppositeFeature, msg.getNotifier());
                        break;
                    }
                    case 1: {
                        EObject oldOtherEnd;
                        EObject otherEnd = (EObject)msg.getNewValue();
                        if (oppositeFeature.resolveOwner()) {
                            otherEnd = (EObject)this.resolve(otherEnd);
                            this.replace(feature, msg.getNewValue(), otherEnd);
                        }
                        if (otherEnd != null) {
                            OppositeFeatureAdapter adapter = AbstractOppositeFeatureManager.this.getOppositeFeatureAdapter(otherEnd);
                            EObject oldValue = (EObject)adapter.getOppositeFeatureMap().get(oppositeFeature);
                            if (oldValue != null) {
                                oldValue.eSet((EStructuralFeature)f, null);
                            }
                            adapter.getOppositeFeatureMap().put(oppositeFeature, msg.getNotifier());
                            break;
                        }
                        EStructuralFeature targetFeature = (EStructuralFeature)f;
                        if (targetFeature.isMany() || (oldOtherEnd = (EObject)msg.getOldValue()) == null) break;
                        OppositeFeatureAdapter adapter = AbstractOppositeFeatureManager.this.getOppositeFeatureAdapter(oldOtherEnd);
                        adapter.getOppositeFeatureMap().put(oppositeFeature, null);
                        break;
                    }
                    case 4: {
                        EObject otherEnd = (EObject)msg.getOldValue();
                        if (oppositeFeature.resolveOwner()) {
                            otherEnd = (EObject)this.resolve(otherEnd);
                        }
                        if (otherEnd == null) break;
                        OppositeFeatureAdapter adapter = AbstractOppositeFeatureManager.this.getOppositeFeatureAdapter(otherEnd);
                        adapter.getOppositeFeatureMap().put(oppositeFeature, null);
                    }
                }
            }
        }

        protected Object resolve(Object object) {
            if (object instanceof InternalEObject && ((InternalEObject)object).eIsProxy()) {
                return ((InternalEObject)this.getTarget()).eResolveProxy((InternalEObject)object);
            }
            return object;
        }

        public void setTarget(Notifier newTarget) {
            if (this.target != null && newTarget != null) {
                throw new IllegalArgumentException("An OppositeFeatureAdapter cannot be associated with 2 targets at the same time.");
            }
            super.setTarget(newTarget);
        }

        private Map<OppositeFeature, Object> createOppositeFeatureMap() {
            HashMap<OppositeFeature, Object> map = new HashMap<OppositeFeature, Object>();
            for (Map.Entry<Class<?>, Set<OppositeFeature>> entry : AbstractOppositeFeatureManager.this.classOppositeFeaturesMap.entrySet()) {
                Class<?> cls = entry.getKey();
                if (!cls.isInstance(this.getTarget())) continue;
                for (OppositeFeature oppositeFeature : entry.getValue()) {
                    map.put(oppositeFeature, null);
                }
            }
            if (map.isEmpty()) {
                this.hasOppositeFeature = false;
                return Collections.emptyMap();
            }
            return map;
        }

        protected Map<OppositeFeature, Object> getOppositeFeatureMap() {
            if (this.oppositeFeatureMap == null && this.hasOppositeFeature) {
                this.oppositeFeatureMap = this.createOppositeFeatureMap();
            }
            if (this.oppositeFeatureMap == null) {
                return Collections.emptyMap();
            }
            return this.oppositeFeatureMap;
        }

        protected List<?> createOppositeFeatureValueList(EObject eObject, OppositeFeature oppositeFeature) {
            return new OppositeFeatureResolvingEList(eObject, oppositeFeature);
        }

        protected void oppositeAdd(OppositeFeature oppositeFeature, Object object) {
            List<?> list = (List<?>)this.getOppositeFeatureMap().get(oppositeFeature);
            if (list == null) {
                list = this.createOppositeFeatureValueList((EObject)this.getTarget(), oppositeFeature);
                this.getOppositeFeatureMap().put(oppositeFeature, list);
            }
            if (!list.contains(object)) {
                list.add(object);
            }
        }

        protected void oppositeRemove(OppositeFeature oppositeFeature, Object object) {
            List<?> list = (List<?>)this.getOppositeFeatureMap().get(oppositeFeature);
            if (list == null) {
                list = this.createOppositeFeatureValueList((EObject)this.getTarget(), oppositeFeature);
                this.getOppositeFeatureMap().put(oppositeFeature, list);
            }
            list.remove(object);
        }

        private void replace(EStructuralFeature feature, Object oldValue, EObject newValue) {
            if (newValue != null && !newValue.eIsProxy() && newValue != oldValue) {
                EObject eObject = (EObject)this.getTarget();
                boolean notify = eObject.eDeliver();
                try {
                    try {
                        eObject.eSetDeliver(false);
                        EcoreUtil.replace((EObject)eObject, (EStructuralFeature)feature, (Object)oldValue, (Object)newValue);
                    }
                    catch (Exception exception) {
                        eObject.eSetDeliver(notify);
                    }
                }
                finally {
                    eObject.eSetDeliver(notify);
                }
            }
        }

        public Collection<OppositeFeature> getOppositeFeatures() {
            return this.getOppositeFeatureMap().keySet();
        }

        public Object getOppositeFeatureValue(OppositeFeature feature) {
            Object value = this.getOppositeFeatureMap().get(feature);
            if (feature.isMany()) {
                if (value == null) {
                    return Collections.EMPTY_LIST;
                }
                return ((OppositeFeatureResolvingEList)((Object)value)).getUnmodifiableList();
            }
            if (value instanceof EObject && ((EObject)value).eResource() == null) {
                this.getOppositeFeatureMap().put(feature, null);
                return null;
            }
            Object resolved = this.resolve(value);
            if (resolved != value) {
                this.getOppositeFeatureMap().put(feature, resolved);
                value = resolved;
            }
            return value;
        }
    }
}

