/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma.ecore.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OppositeFeature {
    private String name;
    private EStructuralFeature targetFeature;
    private boolean isMany;
    private boolean resolveOwner = true;
    private Class ownerClass;
    public static final Map classOppositeFeaturesMap = new HashMap();
    public static final Map featureOppositeFeatureMap = new HashMap();

    public OppositeFeature(Class ownerClass, String name, EStructuralFeature targetFeature, boolean isMany, boolean resolveOwner) {
        this.ownerClass = ownerClass;
        this.name = name;
        this.targetFeature = targetFeature;
        this.isMany = isMany;
        this.resolveOwner = resolveOwner;
    }

    public OppositeFeature(Class ownerClass, String name, EStructuralFeature targetFeature, boolean isMany) {
        this(ownerClass, name, targetFeature, isMany, true);
    }

    public Class getOwnerClass() {
        return this.ownerClass;
    }

    public boolean isMany() {
        return this.isMany;
    }

    public String getName() {
        return this.name;
    }

    public EStructuralFeature getTargetFeature() {
        return this.targetFeature;
    }

    public int getFeatureID() {
        return -1 - this.targetFeature.getFeatureID();
    }

    public boolean resolveOwner() {
        return this.resolveOwner;
    }

    public String toString() {
        return String.valueOf(this.name) + "[targetFeature=" + this.targetFeature + ", isMany=" + this.isMany + "]";
    }

    public static final void registerOppositeFeature(OppositeFeature oppositeFeature) {
        Class cls = oppositeFeature.getOwnerClass();
        HashSet<OppositeFeature> features = (HashSet<OppositeFeature>)classOppositeFeaturesMap.get(cls);
        if (features == null) {
            features = new HashSet<OppositeFeature>();
            classOppositeFeaturesMap.put(cls, features);
        }
        features.add(oppositeFeature);
        featureOppositeFeatureMap.put(oppositeFeature.getTargetFeature(), oppositeFeature);
    }

    public static final OppositeFeature getOppositeFeature(EStructuralFeature feature) {
        return (OppositeFeature)featureOppositeFeatureMap.get(feature);
    }
}

