/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VariabilityType implements Enumerator
{
    NA(0, "na", "na"),
    CONTRIBUTES(1, "contributes", "contributes"),
    EXTENDS(2, "extends", "extends"),
    REPLACES(3, "replaces", "replaces"),
    LOCAL_CONTRIBUTION(4, "localContribution", "localContribution"),
    LOCAL_REPLACEMENT(5, "localReplacement", "localReplacement"),
    EXTENDS_REPLACES(6, "extendsReplaces", "extendsReplaces");

    public static final int NA_VALUE = 0;
    public static final int CONTRIBUTES_VALUE = 1;
    public static final int EXTENDS_VALUE = 2;
    public static final int REPLACES_VALUE = 3;
    public static final int LOCAL_CONTRIBUTION_VALUE = 4;
    public static final int LOCAL_REPLACEMENT_VALUE = 5;
    public static final int EXTENDS_REPLACES_VALUE = 6;
    private static final VariabilityType[] VALUES_ARRAY;
    public static final List<VariabilityType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VariabilityType[]{NA, CONTRIBUTES, EXTENDS, REPLACES, LOCAL_CONTRIBUTION, LOCAL_REPLACEMENT, EXTENDS_REPLACES};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VariabilityType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariabilityType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariabilityType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariabilityType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariabilityType get(int value) {
        switch (value) {
            case 0: {
                return NA;
            }
            case 1: {
                return CONTRIBUTES;
            }
            case 2: {
                return EXTENDS;
            }
            case 3: {
                return REPLACES;
            }
            case 4: {
                return LOCAL_CONTRIBUTION;
            }
            case 5: {
                return LOCAL_REPLACEMENT;
            }
            case 6: {
                return EXTENDS_REPLACES;
            }
        }
        return null;
    }

    private VariabilityType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

