/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum WorkOrderType implements Enumerator
{
    FINISH_TO_START(0, "finishToStart", "finishToStart"),
    FINISH_TO_FINISH(1, "finishToFinish", "finishToFinish"),
    START_TO_START(2, "startToStart", "startToStart"),
    START_TO_FINISH(3, "startToFinish", "startToFinish");

    public static final int FINISH_TO_START_VALUE = 0;
    public static final int FINISH_TO_FINISH_VALUE = 1;
    public static final int START_TO_START_VALUE = 2;
    public static final int START_TO_FINISH_VALUE = 3;
    private static final WorkOrderType[] VALUES_ARRAY;
    public static final List<WorkOrderType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new WorkOrderType[]{FINISH_TO_START, FINISH_TO_FINISH, START_TO_START, START_TO_FINISH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static WorkOrderType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            WorkOrderType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static WorkOrderType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            WorkOrderType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static WorkOrderType get(int value) {
        switch (value) {
            case 0: {
                return FINISH_TO_START;
            }
            case 1: {
                return FINISH_TO_FINISH;
            }
            case 2: {
                return START_TO_START;
            }
            case 3: {
                return START_TO_FINISH;
            }
        }
        return null;
    }

    private WorkOrderType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

