/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.impl.ContentElementImpl;
import org.eclipse.epf.uma.impl.ProcessElementImpl;
import org.eclipse.epf.uma.util.UmaUtil;

public final class ContentDescriptionFactory {
    private static final Map<EClass, EClass> contentDescClassMap = new HashMap<EClass, EClass>();

    static {
        contentDescClassMap.put(UmaPackage.eINSTANCE.getPractice(), UmaPackage.eINSTANCE.getPracticeDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getRole(), UmaPackage.eINSTANCE.getRoleDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getTask(), UmaPackage.eINSTANCE.getTaskDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getTemplate(), UmaPackage.eINSTANCE.getGuidanceDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getExample(), UmaPackage.eINSTANCE.getGuidanceDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getReusableAsset(), UmaPackage.eINSTANCE.getGuidanceDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getWhitepaper(), UmaPackage.eINSTANCE.getGuidanceDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getArtifact(), UmaPackage.eINSTANCE.getArtifactDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getDeliverable(), UmaPackage.eINSTANCE.getDeliverableDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getOutcome(), UmaPackage.eINSTANCE.getWorkProductDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getRoleDescriptor(), UmaPackage.eINSTANCE.getDescriptorDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getCompositeRole(), UmaPackage.eINSTANCE.getDescriptorDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getTaskDescriptor(), UmaPackage.eINSTANCE.getDescriptorDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getWorkProductDescriptor(), UmaPackage.eINSTANCE.getDescriptorDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getMilestone(), UmaPackage.eINSTANCE.getBreakdownElementDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getTeamProfile(), UmaPackage.eINSTANCE.getBreakdownElementDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getActivity(), UmaPackage.eINSTANCE.getActivityDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getIteration(), UmaPackage.eINSTANCE.getActivityDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getPhase(), UmaPackage.eINSTANCE.getActivityDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getCapabilityPattern(), UmaPackage.eINSTANCE.getProcessDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getDeliveryProcess(), UmaPackage.eINSTANCE.getDeliveryProcessDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getProcessPlanningTemplate(), UmaPackage.eINSTANCE.getProcessDescription());
    }

    public static EClass getContentDescriptionType(EClass describableElementType) {
        EClass type = contentDescClassMap.get(describableElementType);
        if (type == null && UmaPackage.eINSTANCE.getDescribableElement().isSuperTypeOf(describableElementType)) {
            type = UmaPackage.eINSTANCE.getContentDescription();
        }
        return type;
    }

    public static final ContentDescription createContentDescription(DescribableElement e) {
        EClass eClass = contentDescClassMap.get(e.eClass());
        if (eClass == null) {
            eClass = UmaPackage.eINSTANCE.getContentDescription();
        }
        ContentDescription content = (ContentDescription)UmaFactory.eINSTANCE.create(eClass);
        content.setName(UmaUtil.createContentDescriptionName(e));
        content.setGuid(UmaUtil.generateGUID(e.getGuid()));
        return content;
    }

    public static ContentDescription createContentDescription(ContentElement e) {
        return ContentDescriptionFactory.createContentDescription(e, false);
    }

    public static ContentDescription createContentDescription(DescribableElement e, boolean saveContentOnly) {
        return ContentDescriptionFactory.createContentDescription(e);
    }

    public static ContentDescription createContentDescription(ContentElement e, boolean saveContentOnly) {
        ContentDescription description = ContentDescriptionFactory.createContentDescription((DescribableElement)e);
        return description;
    }

    public static boolean hasPresentation(MethodElement e) {
        if (e instanceof ContentElementImpl) {
            return ((ContentElementImpl)e).basicGetPresentation() != null;
        }
        if (e instanceof ProcessElementImpl) {
            return ((ProcessElementImpl)e).basicGetPresentation() != null;
        }
        return false;
    }

    public static EClass getContentDescriptionEClass(DescribableElement e) {
        return contentDescClassMap.get(e.eClass());
    }

    public static void main(String[] args) throws Exception {
        String input = args[0];
        System.out.println("input: '" + input + "'");
        System.out.println("Java's hash code: " + input.hashCode());
        System.out.println("new GUID: " + UmaUtil.generateGUID(input));
    }
}

