/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma.util;

import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.MethodUnit;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.IUmaUtilProvider;
import org.eclipse.epf.uma.util.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UmaUtil {
    public static EReference MethodElement_UdtList = UmaUtil.createReference("udtList");
    public static OppositeFeature UdtListOpposite = new OppositeFeature(MethodElement.class, "udtListOpposite", (EStructuralFeature)MethodElement_UdtList, true);
    public static final String Unresolved = new String("unresolved");
    private static IUmaUtilProvider provider;
    public static Set<String> unresolvedGuidSet;

    static {
        unresolvedGuidSet = new HashSet<String>();
    }

    public static EReference createReference(String name) {
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.eSetDeliver(false);
        ref.setName(name);
        ref.setContainment(false);
        ref.setUpperBound(-1);
        ref.setEType((EClassifier)UmaPackage.eINSTANCE.getMethodElement());
        return ref;
    }

    public static EAttribute createAttribute(String name) {
        EAttribute att = EcoreFactory.eINSTANCE.createEAttribute();
        att.eSetDeliver(false);
        att.setName(name);
        att.setEType(UmaPackage.eINSTANCE.getContentDescription_MainDescription().getEType());
        return att;
    }

    private static IUmaUtilProvider getProvider() {
        return provider;
    }

    public static void setProvider(IUmaUtilProvider provider) {
        UmaUtil.provider = provider;
    }

    public static void setUnresolved(MethodElement element) {
        element.setName(Unresolved);
    }

    public static boolean isUnresolved(MethodElement element) {
        return element.getName() == Unresolved;
    }

    public static List<MethodElement> filterOutUnresolved(List<MethodElement> list) {
        ArrayList<MethodElement> filteredList = new ArrayList<MethodElement>();
        if (list != null && !list.isEmpty()) {
            for (MethodElement element : list) {
                if (UmaUtil.isUnresolved(element) || !UmaUtil.isInLibrary(element)) continue;
                filteredList.add(element);
            }
        }
        return filteredList;
    }

    public static void replace(MethodElement oldElement, MethodElement newElement) {
        EList features = oldElement.eClass().getEAllStructuralFeatures();
        if (features != null) {
            int size = features.size();
            int i = 0;
            while (i < size) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                if (feature != UmaPackage.eINSTANCE.getMethodElement_Guid()) {
                    Object newValue = newElement.eGet(feature);
                    oldElement.eSet(feature, newValue);
                }
                ++i;
            }
        }
    }

    public static boolean hasDirectResource(EObject e) {
        Resource resource = e.eResource();
        return resource != null && resource.getContents().contains((Object)e);
    }

    public static Collection<Resource> getResources(EObject e) {
        HashSet<Resource> resources = new HashSet<Resource>();
        UmaUtil.getResources(e, resources);
        return resources;
    }

    public static void getResources(EObject e, Collection<Resource> resources) {
        if (UmaUtil.hasDirectResource(e)) {
            resources.add(e.eResource());
        } else {
            Iterator iter = e.eContents().iterator();
            while (iter.hasNext()) {
                UmaUtil.getResources((EObject)iter.next(), resources);
            }
        }
    }

    public static Object getAdapter(EObject eObj, Class cls) {
        for (Adapter adapter : eObj.eAdapters()) {
            if (!cls.isInstance(adapter)) continue;
            return adapter;
        }
        return null;
    }

    public static void removeAllAdapters(EObject eObject) {
        TreeIterator iter = eObject.eAllContents();
        while (iter.hasNext()) {
            EObject o = (EObject)iter.next();
            o.eAdapters().clear();
        }
    }

    public static MethodPackage findMethodPackage(List methodPackages, String name) {
        int i = methodPackages.size() - 1;
        while (i > -1) {
            MethodPackage pkg;
            Object obj = methodPackages.get(i);
            if (obj instanceof MethodPackage && name.equals((pkg = (MethodPackage)obj).getName())) {
                return pkg;
            }
            --i;
        }
        return null;
    }

    public static MethodPackage findMethodPackage(MethodPlugin methodPlugin, String[] path) {
        MethodPackage pkg = null;
        List<MethodPackage> list = methodPlugin.getMethodPackages();
        int i = 0;
        while (i < path.length) {
            pkg = UmaUtil.findMethodPackage(list, path[i]);
            if (pkg == null) {
                return null;
            }
            list = pkg.getChildPackages();
            ++i;
        }
        return pkg;
    }

    public static Activity getParentActivity(BreakdownElement e) {
        return e.getSuperActivities();
    }

    public static Activity getOwningActivity(WorkOrder workOrder) {
        ProcessPackage pkg = (ProcessPackage)workOrder.eContainer();
        for (ProcessElement element : pkg.getProcessElements()) {
            if (!(element instanceof Activity)) continue;
            return (Activity)element;
        }
        return null;
    }

    public static ContentPackage findContentPackage(List methodPackages, String name) {
        int i = methodPackages.size() - 1;
        while (i > -1) {
            ContentPackage pkg;
            Object obj = methodPackages.get(i);
            if (obj instanceof ContentPackage && name.equals((pkg = (ContentPackage)obj).getName())) {
                return pkg;
            }
            --i;
        }
        return null;
    }

    public static ContentPackage findContentPackage(MethodPlugin methodPlugin, String[] path) {
        ContentPackage pkg = null;
        List<MethodPackage> list = methodPlugin.getMethodPackages();
        int i = 0;
        while (i < path.length) {
            pkg = UmaUtil.findContentPackage(list, path[i]);
            if (pkg == null) {
                return null;
            }
            list = pkg.getChildPackages();
            ++i;
        }
        return pkg;
    }

    public static MethodPlugin getMethodPlugin(EObject element) {
        EObject obj = element;
        while (obj != null) {
            if (obj instanceof MethodPlugin) {
                return (MethodPlugin)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public static MethodLibrary getMethodLibrary(EObject element) {
        EObject obj = element;
        while (obj != null) {
            if (obj instanceof MethodLibrary) {
                return (MethodLibrary)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public static EObject getTopContainer(EObject element) {
        EObject container = null;
        EObject obj = element.eContainer();
        while (obj != null) {
            container = obj;
            obj = obj.eContainer();
        }
        return container;
    }

    public static ContentPackage getContentPackage(EObject element) {
        EObject obj = element;
        while (obj != null) {
            if (obj instanceof ContentPackage) {
                return (ContentPackage)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public static ProcessPackage getProcessPackage(EObject element) {
        EObject obj = element;
        while (obj != null) {
            if (obj instanceof ProcessPackage) {
                return (ProcessPackage)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public static Diagram getDiagram(EObject element) {
        EObject obj = element;
        while (obj != null) {
            if (obj instanceof Diagram) {
                return (Diagram)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public static boolean isContainedByContentPackage(EObject element, ContentPackage contentPackage) {
        return UmaUtil.isContainedBy(element, contentPackage);
    }

    public static boolean isContainedBy(EObject eObj, Object container) {
        if (eObj == null) {
            return false;
        }
        EObject obj = eObj.eContainer();
        while (obj != null) {
            if (obj == container) {
                return true;
            }
            obj = obj.eContainer();
        }
        return false;
    }

    public static String generateGUID() {
        return EcoreUtil.generateUUID();
    }

    public static String createContentDescriptionName(MethodElement e) {
        return String.valueOf(e.getName()) + ',' + e.getGuid();
    }

    public static void getAllSupers(List supers, VariabilityElement e, VariabilityType type) {
        VariabilityElement base = e.getVariabilityBasedOnElement();
        if (base != null && e.getVariabilityType() == type && !supers.contains(base)) {
            supers.add(base);
            UmaUtil.getAllSupers(supers, base, type);
        }
    }

    public static void getAllSupersBoth(List supers, VariabilityElement e, VariabilityType type1, VariabilityType type2) {
        VariabilityElement base = e.getVariabilityBasedOnElement();
        if (!(base == null || e.getVariabilityType() != type1 && e.getVariabilityType() != type2 || supers.contains(base))) {
            supers.add(base);
            UmaUtil.getAllSupersBoth(supers, base, type1, type2);
        }
    }

    public static Class getClassOfContentElement(ContentElement contentElement) {
        if (contentElement instanceof Role) {
            return Role.class;
        }
        if (contentElement instanceof Task) {
            return Task.class;
        }
        if (contentElement instanceof WorkProduct) {
            return WorkProduct.class;
        }
        if (contentElement instanceof Guidance) {
            return Guidance.class;
        }
        if (contentElement instanceof Domain) {
            return Domain.class;
        }
        if (contentElement instanceof Discipline) {
            return Discipline.class;
        }
        if (contentElement instanceof DisciplineGrouping) {
            return DisciplineGrouping.class;
        }
        if (contentElement instanceof RoleSet) {
            return RoleSet.class;
        }
        if (contentElement instanceof RoleSetGrouping) {
            return RoleSetGrouping.class;
        }
        if (contentElement instanceof WorkProductType) {
            return WorkProductType.class;
        }
        return Object.class;
    }

    public static WorkOrder createDefaultWorkOrder(WorkBreakdownElement succ, WorkBreakdownElement pred) {
        return UmaUtil.createDefaultWorkOrder(succ, pred, true);
    }

    public static WorkOrder createDefaultWorkOrder(WorkBreakdownElement succ, WorkBreakdownElement pred, boolean link) {
        WorkOrder wo = UmaFactory.eINSTANCE.createWorkOrder();
        wo.setPred(pred);
        if (link) {
            succ.getLinkToPredecessor().add(wo);
        }
        return wo;
    }

    public static WorkOrder findWorkOrder(WorkBreakdownElement e, Object predecessor) {
        for (WorkOrder workOrder : e.getLinkToPredecessor()) {
            if (workOrder.getPred() != predecessor) continue;
            return workOrder;
        }
        return null;
    }

    public static Collection<WorkOrder> findWorkOrder(WorkBreakdownElement e, WorkBreakdownElement predecessor, boolean includeBase) {
        if (!includeBase) {
            WorkOrder wo = UmaUtil.findWorkOrder(e, predecessor);
            return wo == null ? Collections.emptyList() : Collections.singletonList(wo);
        }
        ArrayList<WorkOrder> workOrders = new ArrayList<WorkOrder>();
        UmaUtil.collectWorkOrders(workOrders, e, predecessor);
        return workOrders;
    }

    public static void collectWorkOrders(Collection<WorkOrder> workOrders, WorkBreakdownElement e, Object predecessor) {
        VariabilityElement ve;
        for (WorkOrder workOrder : e.getLinkToPredecessor()) {
            if (workOrder.getPred() != predecessor) continue;
            workOrders.add(workOrder);
        }
        if (predecessor instanceof VariabilityElement && (ve = ((VariabilityElement)predecessor).getVariabilityBasedOnElement()) != null) {
            UmaUtil.collectWorkOrders(workOrders, e, ve);
        }
    }

    public static WorkOrder removeWorkOrder(WorkBreakdownElement e, Object predecessor) {
        Iterator<WorkOrder> iterator = e.getLinkToPredecessor().iterator();
        while (iterator.hasNext()) {
            WorkOrder order = iterator.next();
            if (order.getPred() != predecessor) continue;
            iterator.remove();
            return order;
        }
        return null;
    }

    public static ProcessComponent getProcessComponent(MethodElement e) {
        MethodElement container = e;
        while (container != null && !(container instanceof ProcessComponent)) {
            container = container.eContainer();
        }
        if (container != null) {
            return (ProcessComponent)container;
        }
        return null;
    }

    public static MethodUnit getMethodUnit(MethodElement e) {
        MethodElement container = e;
        while (container != null && !(container instanceof MethodUnit)) {
            container = container.eContainer();
        }
        if (container != null) {
            return (MethodUnit)container;
        }
        return null;
    }

    public static boolean hasReference(MethodPlugin plugin, MethodPlugin base) {
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)plugin.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            EObject ref = (EObject)featureIterator.next();
            EStructuralFeature f = featureIterator.feature();
            if (f == UmaPackage.eINSTANCE.getMethodPlugin_Bases() || UmaUtil.getMethodPlugin(ref) != base) continue;
            return true;
        }
        TreeIterator iter = plugin.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (element instanceof ProcessElement) continue;
            for (EObject ref : element.eCrossReferences()) {
                if (UmaUtil.getMethodPlugin(ref) != base) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean removeReferences(MethodPlugin plugin, MethodPlugin base) {
        TreeIterator iter = plugin.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (element instanceof ProcessElement) continue;
            EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)element.eCrossReferences().iterator();
            while (featureIterator.hasNext()) {
                EObject ref = (EObject)featureIterator.next();
                if (UmaUtil.getMethodPlugin(ref) != base) continue;
                EStructuralFeature f = featureIterator.feature();
                if (f.isMany()) {
                    ((Collection)element.eGet(f)).remove(ref);
                    continue;
                }
                element.eSet(f, null);
            }
        }
        return false;
    }

    public static String getMessage(IStatus status) {
        String msg = status.getMessage();
        if (status.isMultiStatus()) {
            StringBuffer strBuf = new StringBuffer(msg);
            IStatus[] statuses = status.getChildren();
            int i = 0;
            while (i < statuses.length) {
                strBuf.append('\n').append(statuses[i].getMessage());
                ++i;
            }
            msg = strBuf.toString();
        }
        if (msg != null && msg.trim().length() == 0) {
            msg = null;
        }
        return msg;
    }

    public static final String generateGUID(String baseGUID) {
        return GUID.generate(baseGUID);
    }

    public static void main(String[] args) {
        System.out.println(UmaUtil.generateGUID());
    }

    public static boolean isSynFree() {
        IUmaUtilProvider p = UmaUtil.getProvider();
        return p == null ? true : p.isSynFree();
    }

    public static boolean isSynFreeLibrary(MethodLibrary lib) {
        IUmaUtilProvider p = UmaUtil.getProvider();
        return p == null ? true : p.isSynFreeLibrary(lib);
    }

    public static boolean isSynFreePlugin(MethodPlugin plugin) {
        IUmaUtilProvider p = UmaUtil.getProvider();
        return p == null ? true : p.isSynFreePlugin(plugin);
    }

    public static boolean isSynFreeProcess(Process proc) {
        IUmaUtilProvider p = UmaUtil.getProvider();
        return p == null ? true : p.isSynFreeProcess(proc);
    }

    public static void setSynFreeLibrary(MethodLibrary lib, boolean value) {
        IUmaUtilProvider p = UmaUtil.getProvider();
        if (p == null) {
            return;
        }
        p.setSynFreeLibrary(lib, value);
    }

    public static void setSynFreePlugin(MethodPlugin plugin, boolean value) {
        IUmaUtilProvider p = UmaUtil.getProvider();
        if (p == null) {
            return;
        }
        p.setSynFreePlugin(plugin, value);
    }

    public static void setSynFreeProcess(Process proc, boolean value) {
        IUmaUtilProvider p = UmaUtil.getProvider();
        if (p == null) {
            return;
        }
        p.setSynFreeProcess(proc, value);
    }

    public static boolean isInLibrary(MethodElement element) {
        if (element == null) {
            return false;
        }
        EObject cont = element.eContainer();
        while (cont instanceof MethodElement) {
            if (cont instanceof MethodLibrary) {
                return true;
            }
            cont = cont.eContainer();
        }
        return false;
    }

    public static Set<MethodPackage> getDecendentPackages(MethodPackage pkg) {
        HashSet<MethodPackage> set = new HashSet<MethodPackage>();
        for (MethodPackage childPkg : pkg.getChildPackages()) {
            set.add(childPkg);
            set.addAll(UmaUtil.getDecendentPackages(childPkg));
        }
        return set;
    }

    public static Set<MethodPackage> getAllMethodPackages(MethodPlugin plugin) {
        HashSet<MethodPackage> set = new HashSet<MethodPackage>();
        for (MethodPackage pkg : plugin.getMethodPackages()) {
            set.add(pkg);
            set.addAll(UmaUtil.getDecendentPackages(pkg));
        }
        return set;
    }

    public static Process getProcess(MethodElement e) {
        ProcessComponent procComp = UmaUtil.getProcessComponent(e);
        if (procComp != null) {
            Process proc = procComp.getProcess();
            return proc;
        }
        return null;
    }

    public static Scope getScope(Process proc) {
        if (proc == null || !(proc.getDefaultContext() instanceof Scope)) {
            return null;
        }
        Scope scope = (Scope)proc.getDefaultContext();
        return scope;
    }

    public static boolean isConfigFree(Process process) {
        if (UmaUtil.getScope(process) != null) {
            return true;
        }
        if (process.getDefaultContext() == null && process.getValidContext().isEmpty()) {
            return true;
        }
        if (!process.getValidContext().isEmpty()) {
            return process.getValidContext().get(0) instanceof Scope;
        }
        return false;
    }

    public static void dumpUmaTypes() {
        HashSet set = new HashSet();
        ArrayList<String> types = new ArrayList<String>();
        Method[] methodArray = UmaFactory.eINSTANCE.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Class<?> cls = m.getReturnType();
            if (cls != null && set.add(cls)) {
                types.add(cls.getName());
            }
            ++n2;
        }
        Collections.sort(types);
        for (String type : types) {
            System.out.println(type);
        }
    }

    public static Set<Resource> getElementResources(Set<? extends MethodElement> elements) {
        if (elements == null || elements.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<Resource> resources = new HashSet<Resource>();
        for (MethodElement methodElement : elements) {
            Resource res = methodElement.eResource();
            if (res == null) continue;
            resources.add(res);
        }
        return resources;
    }

    public static List<String> getResourceFilePaths(Set<Resource> resources) {
        if (resources == null || resources.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (Resource res : resources) {
            ret.add(res.getURI().toFileString());
        }
        return ret;
    }

    private static class GUID {
        private static MessageDigest md5 = null;
        private static final char[] BASE64_DIGITS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};

        private GUID() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static MessageDigest getMD5() {
            if (md5 != null) return md5;
            Class<GUID> clazz = GUID.class;
            synchronized (GUID.class) {
                if (md5 != null) return md5;
                try {
                    md5 = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                return md5;
            }
        }

        public static final String generate(String baseGUID) {
            MessageDigest md5 = GUID.getMD5();
            md5.update(baseGUID.getBytes());
            byte[] hash = md5.digest();
            char[] buffer = new char[23];
            buffer[0] = 45;
            int i = 0;
            while (i < 5) {
                buffer[4 * i + 1] = BASE64_DIGITS[hash[i * 3] >> 2 & 0x3F];
                buffer[4 * i + 2] = BASE64_DIGITS[hash[i * 3] << 4 & 0x30 | hash[i * 3 + 1] >> 4 & 0xF];
                buffer[4 * i + 3] = BASE64_DIGITS[hash[i * 3 + 1] << 2 & 0x3C | hash[i * 3 + 2] >> 6 & 3];
                buffer[4 * i + 4] = BASE64_DIGITS[hash[i * 3 + 2] & 0x3F];
                ++i;
            }
            buffer[21] = BASE64_DIGITS[hash[15] >> 2 & 0x3F];
            buffer[22] = BASE64_DIGITS[hash[15] << 4 & 0x30];
            return new String(buffer);
        }
    }
}

