/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.epf.uma.ecore.IUserDefinedTypeMeta;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDefinedTypeMeta
implements IUserDefinedTypeMeta {
    public static final String QReference_ = "qReference_";
    public static final UserDefinedTypeMeta noneValue = new UserDefinedTypeMeta();
    public static final String Type_Practice = "Practice";
    public static final String _typeName = "typeName";
    public static final String _typeId = "typeId";
    public static final String _problems = "problems";
    public static final String _goals = "goals";
    public static final String _background = "background";
    public static final String _mainDescription = "mainDescription";
    public static final String _application = "application";
    public static final String _levelsOfAdoption = "levelsOfAdoption";
    public static final String _additionalInfo = "additionalInfo";
    public static final String _icon = "icon";
    public static final String _iconRelative = "iconRelative";
    public static final String _shapeIcon = "shapeIcon";
    public static final String _shapeIconRelative = "shapeIconRelative";
    public static final String _referenceQualifiers = "referenceQualifiers";
    public static final String _referenceQualifierNames = "referenceQualifierNames";
    public static final String _generateTreebrowserFolders = "generateTreebrowserFolders";
    public static String[] rteNames = new String[]{"typeName", "typeId", "problems", "goals", "background", "mainDescription", "application", "levelsOfAdoption", "additionalInfo", "icon", "iconRelative", "shapeIcon", "shapeIconRelative", "referenceQualifiers", "referenceQualifierNames"};
    private Map<String, String> rteNameMap;
    private String id;
    private Set<EReference> qualifiedReferences;
    private boolean qualifiedReferencesLoaded = false;
    private Map<String, String> referenceQualifiedNameToIdMap;
    private Map<String, String> referenceQualifiedIdToNameMap;

    public static UserDefinedTypeMeta newPracticeUtdpeMeta(String typeId) {
        UserDefinedTypeMeta meta = new UserDefinedTypeMeta();
        meta.setId(UserDefinedTypeMeta.getPracticeUdtId(typeId));
        return meta;
    }

    public static String getPracticeUdtId(String typeId) {
        return "Practice:" + typeId;
    }

    public String getTypeId() {
        return this.getRteNameMap().get(_typeId);
    }

    public Map<String, String> getRteNameMap() {
        if (this.rteNameMap == null) {
            this.rteNameMap = new HashMap<String, String>();
        }
        return this.rteNameMap;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean same(UserDefinedTypeMeta other) {
        if (other == null) {
            return false;
        }
        if (!this.same(this.id, other.id)) {
            return false;
        }
        String[] stringArray = rteNames;
        int n = rteNames.length;
        int n2 = 0;
        while (n2 < n) {
            String otherValue;
            String thisValue;
            String name = stringArray[n2];
            if (!(name.equals(_icon) || name.equals(_shapeIcon) || this.same(thisValue = this.getRteNameMap().get(name), otherValue = other.getRteNameMap().get(name)))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean same(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private List<String> convertStringsToList(String string) {
        ArrayList<String> strList = new ArrayList<String>();
        if (string == null) {
            string = "";
        }
        String[] strings = string.split("\\,");
        int i = 0;
        while (i < strings.length) {
            if (strings[i].trim().length() > 0) {
                strList.add(strings[i].trim());
            }
            ++i;
        }
        return strList;
    }

    public boolean isQualifiedRefernce(EReference ref) {
        return this.getQualifiedReferences().contains(ref);
    }

    public Set<EReference> getQualifiedReferences() {
        if (this.qualifiedReferences == null) {
            this.qualifiedReferences = new LinkedHashSet<EReference>();
        }
        String idStrValue = this.getRteNameMap().get(_referenceQualifiers);
        String nameStrValue = this.getRteNameMap().get(_referenceQualifierNames);
        if (idStrValue == null || idStrValue.trim().length() == 0) {
            this.qualifiedReferencesLoaded = false;
            if (!this.qualifiedReferences.isEmpty()) {
                this.qualifiedReferences.clear();
            }
        } else if (!this.qualifiedReferencesLoaded) {
            if (!this.qualifiedReferences.isEmpty()) {
                this.qualifiedReferences.clear();
            }
            List<String> refIds = this.convertStringsToList(idStrValue);
            List<String> refNames = this.convertStringsToList(nameStrValue);
            if (refIds.size() != refNames.size()) {
                refNames = refIds;
            }
            this.getReferenceQualifiedNameToIdMap().clear();
            this.getReferenceQualifiedIdToNameMap().clear();
            int i = 0;
            while (i < refIds.size()) {
                String refId = QReference_ + refIds.get(i);
                String refName = refNames.get(i);
                this.getReferenceQualifiedNameToIdMap().put(refName, refId);
                this.getReferenceQualifiedIdToNameMap().put(refId, refName);
                EReference ref = UmaUtil.createReference(refId);
                this.qualifiedReferences.add(ref);
                ++i;
            }
            this.qualifiedReferencesLoaded = true;
        }
        return this.qualifiedReferences;
    }

    private Map<String, String> getReferenceQualifiedNameToIdMap() {
        if (this.referenceQualifiedNameToIdMap == null) {
            this.referenceQualifiedNameToIdMap = new HashMap<String, String>();
        }
        return this.referenceQualifiedNameToIdMap;
    }

    private Map<String, String> getReferenceQualifiedIdToNameMap() {
        if (this.referenceQualifiedIdToNameMap == null) {
            this.referenceQualifiedIdToNameMap = new HashMap<String, String>();
        }
        return this.referenceQualifiedIdToNameMap;
    }

    public String getReferenceQualifierName(String referenceQualifierId) {
        this.getQualifiedReferences();
        return this.getReferenceQualifiedIdToNameMap().get(referenceQualifierId);
    }

    public String getReferenceQualifierId(String referenceQualifierName) {
        this.getQualifiedReferences();
        return this.getReferenceQualifiedNameToIdMap().get(referenceQualifierName);
    }

    public String[] getReferenceQualifierNames() {
        this.getQualifiedReferences();
        Set<String> nameSet = this.getReferenceQualifiedNameToIdMap().keySet();
        ArrayList<String> nameList = new ArrayList<String>(nameSet);
        Collections.sort(nameList);
        return nameList.toArray(new String[0]);
    }
}

