/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.validation.constraints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.validation.service.AbstractTraversalStrategy;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DiagramElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;

public class LibraryTraversalStrategy
extends AbstractTraversalStrategy {
    public static final String TRAVERSAL_TYPE = "TRAVERSAL_TYPE";
    public static final int SHADOW = 0;
    public static final int DEEP = 1;
    public static final ITraversalStrategy deepTraversalStrategy = new LibraryTraversalStrategy(1);
    private Collection roots;
    private boolean contextChanged = true;
    private int type = 1;

    public static int countElements(Collection traversalRoots, int traversalType) {
        return LibraryTraversalStrategy.countElements(traversalRoots, true, traversalType);
    }

    private static int countElements(Collection traversalRoots, boolean makeDisjoint, int traversalType) {
        int count = 0;
        LibraryIterator iter = new LibraryIterator(traversalRoots, true, traversalType, makeDisjoint);
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        return count;
    }

    public LibraryTraversalStrategy() {
    }

    public LibraryTraversalStrategy(int traversalType) {
        this.type = traversalType;
    }

    public void startTraversal(Collection traversalRoots, IProgressMonitor progressMonitor) {
        this.roots = LibraryTraversalStrategy.makeTargetsDisjoint(traversalRoots);
        super.startTraversal(traversalRoots, progressMonitor);
    }

    private Collection getRoots() {
        return this.roots;
    }

    protected int countElements(Collection ignored) {
        return LibraryTraversalStrategy.countElements(this.getRoots(), false, this.type);
    }

    protected Iterator createIterator(Collection ignored) {
        return new LibraryIterator(this.getRoots(), true, this.type, false){
            private static final long serialVersionUID = -5653134989235663973L;

            public Iterator getChildren(Object obj) {
                if (obj == LibraryTraversalStrategy.this.getRoots()) {
                    return new Iterator(){
                        private final Iterator delegate;
                        {
                            this.delegate = LibraryTraversalStrategy.this.getRoots().iterator();
                        }

                        public boolean hasNext() {
                            return this.delegate.hasNext();
                        }

                        public Object next() {
                            LibraryTraversalStrategy.this.contextChanged = true;
                            return this.delegate.next();
                        }

                        public void remove() {
                            this.delegate.remove();
                        }
                    };
                }
                return super.getChildren(obj);
            }

            public Object next() {
                LibraryTraversalStrategy.this.contextChanged = false;
                return super.next();
            }
        };
    }

    public boolean isClientContextChanged() {
        return this.contextChanged;
    }

    public static Set makeTargetsDisjoint(Collection objects) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (EObject outerNext : objects) {
            for (EObject innerNext : result) {
                if (!EcoreUtil.isAncestor((EObject)innerNext, (EObject)outerNext)) continue;
                outerNext = null;
                break;
            }
            if (outerNext == null) continue;
            result.add(outerNext);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LibraryIterator
    extends EcoreUtil.ContentTreeIterator {
        private static final long serialVersionUID = -1175428027503440970L;
        private int traversalType = 1;

        protected LibraryIterator(Collection emfObjects) {
            super(emfObjects);
        }

        public LibraryIterator(Collection eObjects, boolean isResolveProxies, int traversalType, boolean disjoint) {
            super((Object)(disjoint ? LibraryTraversalStrategy.makeTargetsDisjoint(eObjects) : eObjects), isResolveProxies);
            this.traversalType = traversalType;
        }

        protected Iterator<?> getEObjectChildren(EObject object) {
            if (this.traversalType == 1) {
                if (!(object instanceof MethodElement) || object instanceof Constraint || object instanceof DiagramElement) {
                    return Collections.EMPTY_LIST.iterator();
                }
                ArrayList<MethodElement> list = new ArrayList<MethodElement>();
                Iterator it = super.getEObjectChildren(object);
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof MethodElement)) continue;
                    list.add((MethodElement)obj);
                }
                return list.iterator();
            }
            if (object instanceof CustomCategory) {
                return this.getEObjectChildren((EObject)((CustomCategory)object), UmaPackage.Literals.CUSTOM_CATEGORY__CATEGORIZED_ELEMENTS, UmaPackage.Literals.CUSTOM_CATEGORY);
            }
            if (object instanceof ProcessComponent || object instanceof MethodConfiguration || object instanceof ContentElement) {
                return Collections.EMPTY_LIST.iterator();
            }
            if (object instanceof MethodPackage) {
                MethodPackage pkg = (MethodPackage)object;
                if (TngUtil.isPredefined((MethodElement)pkg) && "CustomCategories".equals(pkg.getName())) {
                    ContentPackage hiddenPkg = UmaUtil.findContentPackage((List)pkg.getChildPackages(), (String)"Hidden");
                    if (hiddenPkg != null && !hiddenPkg.getContentElements().isEmpty()) {
                        return hiddenPkg.getContentElements().iterator();
                    }
                    return Collections.EMPTY_LIST.iterator();
                }
                return this.getEObjectChildren((EObject)pkg, UmaPackage.Literals.METHOD_PACKAGE__CHILD_PACKAGES, null);
            }
            if (object instanceof MethodLibrary) {
                return this.getEObjectChildren((EObject)((MethodLibrary)object), new EStructuralFeature[]{UmaPackage.Literals.METHOD_LIBRARY__METHOD_PLUGINS, UmaPackage.Literals.METHOD_LIBRARY__PREDEFINED_CONFIGURATIONS});
            }
            if (object instanceof MethodPlugin) {
                return this.getEObjectChildren(object, UmaPackage.Literals.METHOD_PLUGIN__METHOD_PACKAGES, null);
            }
            if (object == this.object) {
                return ((Collection)object).iterator();
            }
            return Collections.EMPTY_LIST.iterator();
        }

        private Iterator getEObjectChildren(EObject eObject, EStructuralFeature[] features) {
            EContentsEList list = new EContentsEList(eObject, features);
            return this.isResolveProxies() ? list.iterator() : list.basicIterator();
        }

        private Iterator getEObjectChildren(EObject eObject, EReference reference, EClass eClass) {
            Iterator<Object> iter;
            if (reference == UmaPackage.eINSTANCE.getMethodElement_MethodElementProperty()) {
                return Collections.EMPTY_LIST.iterator();
            }
            if (reference.isMany()) {
                boolean resolve = this.isResolveProxies();
                List list = (List)eObject.eGet((EStructuralFeature)reference, resolve);
                iter = !resolve && list instanceof InternalEList ? ((InternalEList)list).basicIterator() : list.iterator();
            } else {
                Object value = eObject.eGet((EStructuralFeature)reference, this.isResolveProxies());
                Iterator<Object> iterator = iter = value != null ? Collections.singletonList(value).iterator() : Collections.EMPTY_LIST.iterator();
            }
            if (eClass == null) {
                return iter;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!eClass.isInstance(o)) continue;
                list.add(o);
            }
            if (list.isEmpty()) {
                return Collections.EMPTY_LIST.iterator();
            }
            return list.iterator();
        }
    }
}

