/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.validation.constraints;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.edit.validation.internal.ValidatorFactory;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.validation.Activator;
import org.eclipse.epf.validation.util.ValidationStatus;

public class NameConstraint
extends AbstractModelConstraint {
    private static final boolean DEBUG = Activator.getDefault().isDebugging();

    private boolean canCheck(Object eObj) {
        return eObj instanceof MethodPlugin || eObj instanceof MethodConfiguration || eObj instanceof ContentPackage || eObj instanceof ProcessComponent || (eObj instanceof ProcessPackage || eObj instanceof ContentElement) && UmaUtil.getProcessComponent((MethodElement)((MethodElement)eObj)) == null;
    }

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (DEBUG) {
            if (eObj instanceof NamedElement) {
                NamedElement e = (NamedElement)eObj;
                System.out.println("NameConstraint.validate(): " + TngUtil.getTypeText((EObject)e) + ": '" + e.getName() + "'");
            }
            if (eObj instanceof Milestone) {
                System.out.println();
            }
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.epf.validation", 0, "", null);
        if (eType == EMFEventType.NULL) {
            if (eObj instanceof MethodElement && TngUtil.isPredefined((MethodElement)((MethodElement)eObj))) {
                return ctx.createSuccessStatus();
            }
            if (eObj instanceof CustomCategory) {
                CustomCategory cc = (CustomCategory)eObj;
                List list = AssociationHelper.getCustomCategories((DescribableElement)cc);
                for (CustomCategory parent : list) {
                    IValidator validator = IValidatorFactory.INSTANCE.createNameValidator((Object)parent, (ContentElement)cc);
                    String msg = validator.isValid(cc.getName());
                    if (msg != null) {
                        multiStatus.add((IStatus)new ValidationStatus(4, 0, msg, cc, (EStructuralFeature)UmaPackage.Literals.NAMED_ELEMENT__NAME));
                    }
                    if ((msg = (validator = IValidatorFactory.INSTANCE.createPresentationNameValidator((Object)parent, (DescribableElement)cc)).isValid(cc.getPresentationName())) == null) continue;
                    multiStatus.add((IStatus)new ValidationStatus(4, 0, msg, cc, (EStructuralFeature)UmaPackage.Literals.METHOD_ELEMENT__PRESENTATION_NAME));
                }
            } else if (this.canCheck(eObj)) {
                NamedElement e = (NamedElement)eObj;
                IValidator validator = IValidatorFactory.INSTANCE.createNameValidator((Object)eObj.eContainer(), e);
                String msg = validator.isValid(e.getName());
                if (msg != null) {
                    multiStatus.add((IStatus)new ValidationStatus(4, 0, msg, e, (EStructuralFeature)UmaPackage.Literals.NAMED_ELEMENT__NAME));
                }
            }
            if (multiStatus.isOK()) {
                return ctx.createSuccessStatus();
            }
            return multiStatus;
        }
        Object newValue = ctx.getFeatureNewValue();
        if (newValue == null || ((String)newValue).length() == 0) {
            return ctx.createFailureStatus(new Object[]{eObj.eClass().getName()});
        }
        return ctx.createSuccessStatus();
    }

    private IStatus checkChildren(EObject object, EReference childFeature, EClass eClass) {
        ArrayList<ValidationStatus> statusList = new ArrayList<ValidationStatus>();
        List children = (List)object.eGet((EStructuralFeature)childFeature);
        HashSet checkedChildren = new HashSet();
        ChildFilter childFilter = new ChildFilter(eClass, checkedChildren);
        for (EObject child : children) {
            NamedElement e;
            IValidator validator;
            String msg;
            if (child instanceof NamedElement && (msg = (validator = IValidatorFactory.INSTANCE.createValidator(object, childFeature, (IFilter)childFilter, child, (EStructuralFeature)UmaPackage.Literals.NAMED_ELEMENT__NAME)).isValid((e = (NamedElement)child).getName())) != null) {
                statusList.add(new ValidationStatus(4, 0, msg, e, (EStructuralFeature)UmaPackage.Literals.NAMED_ELEMENT__NAME));
            }
            if (!(child instanceof DescribableElement) || (msg = (validator = IValidatorFactory.INSTANCE.createValidator(object, childFeature, (IFilter)childFilter, child, (EStructuralFeature)UmaPackage.Literals.METHOD_ELEMENT__PRESENTATION_NAME)).isValid((e = (DescribableElement)child).getPresentationName())) == null) continue;
            statusList.add(new ValidationStatus(4, 0, msg, e, (EStructuralFeature)UmaPackage.Literals.METHOD_ELEMENT__PRESENTATION_NAME));
        }
        if (!statusList.isEmpty()) {
            if (statusList.size() == 1) {
                return (IStatus)statusList.get(0);
            }
            IStatus[] newChildren = new IStatus[statusList.size()];
            statusList.toArray(newChildren);
            return new MultiStatus("org.eclipse.epf.validation", 0, newChildren, "", null);
        }
        return Status.OK_STATUS;
    }

    private static class ChildFilter
    extends ValidatorFactory.TypeFilter {
        private Set checkedChildren;

        public ChildFilter(EClass eClass, Set checkedChildren) {
            super(eClass);
            this.checkedChildren = checkedChildren;
        }

        public boolean accept(Object obj) {
            if (this.checkedChildren.contains(obj)) {
                return false;
            }
            return super.accept(obj);
        }
    }
}

