/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.validation.constraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.validation.Activator;
import org.eclipse.epf.validation.ValidationResources;
import org.eclipse.epf.validation.util.ValidationStatus;
import org.eclipse.osgi.util.NLS;

public class RelationshipConstraint
extends AbstractModelConstraint {
    private static final boolean DEBUG = Activator.getDefault().isDebugging();
    private static final Collection referencesToCheckForCircularDependency = Arrays.asList(UmaPackage.Literals.METHOD_PLUGIN__BASES, UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_BASED_ON_ELEMENT, UmaPackage.Literals.ACTIVITY__BREAKDOWN_ELEMENTS, UmaPackage.Literals.DELIVERABLE__DELIVERED_WORK_PRODUCTS, UmaPackage.Literals.CUSTOM_CATEGORY__CATEGORIZED_ELEMENTS);

    public IStatus validate(IValidationContext ctx) {
        if (DependencyChecker.newCheck) {
            return Status.OK_STATUS;
        }
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (DEBUG && eObj instanceof NamedElement) {
            NamedElement e = (NamedElement)eObj;
            System.out.println("RelationshipConstraint.validate(): " + TngUtil.getTypeText((EObject)e) + ": '" + e.getName() + "'");
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.epf.validation", 0, "", null);
        if (eType == EMFEventType.NULL) {
            ArrayList features = new ArrayList(referencesToCheckForCircularDependency);
            features.retainAll((Collection<?>)eObj.eClass().getEAllReferences());
            for (EReference ref : features) {
                IStatus status;
                if (ref.isMany()) {
                    for (Object o : (List)eObj.eGet((EStructuralFeature)ref)) {
                        IStatus status2 = DependencyChecker.checkCircularDependency((EObject)eObj, (EStructuralFeature)ref, o);
                        if (status2.isOK()) continue;
                        String msg = status2.getMessage();
                        if (StrUtil.isBlank((String)msg)) {
                            msg = NLS.bind((String)ValidationResources.circularDependency_error, (Object)ref.getEContainingClass().getName(), (Object)ref.getName());
                        }
                        multiStatus.add((IStatus)new ValidationStatus(4, 0, msg, eObj, (EStructuralFeature)ref));
                    }
                    continue;
                }
                Object o = eObj.eGet((EStructuralFeature)ref);
                if (o == null || (status = DependencyChecker.checkCircularDependency((EObject)eObj, (EStructuralFeature)ref, (Object)o)).isOK()) continue;
                String msg = status.getMessage();
                if (StrUtil.isBlank((String)msg)) {
                    msg = NLS.bind((String)ValidationResources.circularDependency_error, (Object)ref.getEContainingClass().getName(), (Object)ref.getName());
                }
                multiStatus.add((IStatus)new ValidationStatus(4, 0, msg, eObj, (EStructuralFeature)ref));
            }
            if (multiStatus.isOK()) {
                return ctx.createSuccessStatus();
            }
            return multiStatus;
        }
        return ctx.createSuccessStatus();
    }
}

