/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.search.AbstractJavaSearchResult;
import org.eclipse.jdt.internal.ui.search.JavaMatchFilter;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;

public class JavaSearchResult
extends AbstractJavaSearchResult {
    private final JavaSearchQuery fQuery;
    private final Map<Object, IMatchPresentation> fElementsToParticipants;

    public JavaSearchResult(JavaSearchQuery query) {
        this.fQuery = query;
        this.fElementsToParticipants = new HashMap<Object, IMatchPresentation>();
        this.setActiveMatchFilters(JavaMatchFilter.getLastUsedFilters());
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fQuery.getImageDescriptor();
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public void setActiveMatchFilters(MatchFilter[] filters) {
        super.setActiveMatchFilters(filters);
        JavaMatchFilter.setLastUsedFilters(filters);
    }

    public MatchFilter[] getAllMatchFilters() {
        return JavaMatchFilter.allFilters(this.fQuery);
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    synchronized IMatchPresentation getSearchParticpant(Object element) {
        return this.fElementsToParticipants.get(element);
    }

    boolean addMatch(Match match, IMatchPresentation participant) {
        Object element = match.getElement();
        if (this.fElementsToParticipants.get(element) != null) {
            JavaPlugin.log((IStatus)new Status(2, JavaPlugin.getPluginId(), 0, "A second search participant was found for an element", null));
            return false;
        }
        this.fElementsToParticipants.put(element, participant);
        this.addMatch(match);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        JavaSearchResult javaSearchResult = this;
        synchronized (javaSearchResult) {
            this.fElementsToParticipants.clear();
        }
        super.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatch(Match match) {
        JavaSearchResult javaSearchResult = this;
        synchronized (javaSearchResult) {
            if (this.getMatchCount(match.getElement()) == 1) {
                this.fElementsToParticipants.remove(match.getElement());
            }
        }
        super.removeMatch(match);
    }
}

