# Filters added to this controller will be run for all controllers in the application.
# Likewise, all the methods added will be available for all controllers.
#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class ApplicationController < ActionController::Base
  
  #########
  protected   
  #########
  
  def log_error(exception) #:doc:
    super(exception)
    begin
      # TODO don't send error email when action error causes an error 
      Notifier.deliver_error_report(exception, clean_backtrace(exception), 
      session.instance_variable_get("@data"), 
      params, 
      request.env)
    rescue => e
      logger.error(e)
    end
  end
  
  # all exceptions are redirected to OtherController.error
  def rescue_action_in_public(exception) #:doc:
    flash['error'] = exception.message
    flash['notice'] = "An application error occurred while processing your request. This error was logged and an email was sent to notify the administrator."
    flash['notice'] = 'We\'re sorry, but something went wrong. We\'ve been notified about this issue and we\'ll take a look at it shortly.'
    redirect_to :controller => 'other', :action => 'error'
  end
  
  # instead of an error stack we want to display a nice user friendly error message
  def local_request? #:doc:
    false
  end
  
  # The #authenticate method is used as a <tt>before_hook</tt> in
  # controllers that require the user to be authenticated. If the
  # session does not contain a valid user, the method
  # redirects to the LoginController.login.
  #-- 
  # TODO to have caching of pages per user group add something like :params => params.merge( :utype=> 'admin' ) 
  #++
  def authenticate #:doc:
    unless session['user']
      logger.debug('No session, redirecting to login')
      session['return_to'] = request.request_uri
      redirect_to :controller => 'login' 
      return false
    end
  end
  
  def authenticate_admin #:doc:
    logger.debug("Authenticate admin #{session['user']}, #{session['user'].inspect}")
    if  !admin?
      logger.debug("User not authenticated as admin")
      flash['notice'] = 'Administrators privileges are required to access this function'
      flash['error'] = LoginController::FLASH_UNOT_ADMIN # TODO should be flash.now?
      Notifier::deliver_authorisation_problem(session['user'], session.instance_variable_get("@data"), params, request.env)
      redirect_to :controller => 'other', :action => 'error'
      return false        
    end
  end
  
  def authenticate_cadmin #:doc:
    if  !cadmin?
      flash['notice'] = 'You need to be the central administrator to access this function'
      flash['error'] = LoginController::FLASH_UNOT_CADMIN
      Notifier::deliver_authorisation_problem(session['user'], session.instance_variable_get("@data"), params, request.env)
      redirect_to :controller => 'other', :action => 'error'
      return false
    end
  end
  
end
