# Feedback is created in the portal by authenticated and anonymous users, 
# see OtherController.feedback. This controller together with SitesController
# is used to manage feedback, see SitesController.feedback
#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class FeedbacksController < ApplicationController

  layout 'management'
  
  before_filter :authenticate_cadmin

  verify :method => :post, :only => [:destroy, :update], :add_flash => {'error' => ::FLASH_USE_POST_NOT_GET}, :redirect_to => { :controller => 'other', :action => 'error' }  

  def edit
    @feedback = Feedback.find(params[:id])
  end
  
  def update
    @feedback = Feedback.find(params[:id])
    if @feedback.update_attributes(params[:feedback])
      flash[:notice] = 'Feedback was successfully updated.'
      redirect_to @feedback.request_referer
    else
      render :action => 'edit'
    end
  end
  
  def destroy
    Feedback.find(params[:id]).destroy
    logger.info("destroy en dan #{request.referer}")
    redirect_to request.referer
  end
  
end
