require 'open-uri'

#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class OtherController < ApplicationController

  layout 'management'

  # Action #info displays information this application
  def about
    @version = db_script_version(ENV['EPFWIKI_ROOT_DIR'] + "db/migrate")
    @database_schema = User.find_by_sql('select version from schema_info')[0]
    if  @database_schema.version.to_s == @version.to_s
      @version = nil
    else
      flash.now['warning'] = "Database seems out-of-date. Available scripts are of a higher version. Available is " + @version.to_s + ", installed is " + @database_schema.version.to_s 
    end
  end

  # Action #error is redirected to from ApplicationController.resque_action_in_public
  # to display a userfriendly error message
  def error
  end
  
  # See routes.rb
  def show404
      flash.now['error'] = 'The page you\'ve requested cannot be found.'
      render :action => 'error', :status => 404 
  end
 
end
