#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class UsersController < ApplicationController
  
  layout 'management'
  
  before_filter :authenticate, :except => [:show]
  before_filter :authenticate_admin, :only => [:list, :admin]
  before_filter :authenticate_cadmin, :only => [:destroy, :cadmin, :adminmessage]
  require 'ftools'
  
  verify :method => :post, :only => [:send_report, :destroy, :cadmin, :admin, :resend],:add_flash => {'error' => ::FLASH_USE_POST_NOT_GET}, :redirect_to => { :controller => 'other', :action => 'error' }  

  FLASH_REPORT_SENT = "Report sent!"
  FLASH_FAILED_TO_RESEND_PW = "New password could not be saved!"
  FLASH_NO_LONGER_CADMIN = "You are no longer the central administrator"  
  
  def index
    redirect_to :action => 'list'
  end
  
  def list
    @admins = User.find_all_by_admin('Y')
    @users = User.find_all_by_admin('N')
    @cadmin = User.find_central_admin
  end    
  
  def send_report
    Notifier::deliver_summary(params.merge(:user => session['user']))
    flash['success'] = FLASH_REPORT_SENT
    redirect_to :action => 'account', :id => session['user'].id
  end
  
  # TODO caching of this page
  def show
    @user = User.find(params[:id])
    @versions = UserVersion.find(:all, :order => 'created_on DESC', :conditions => ['user_id=?',@user.id])
    @comments = Comment.find(:all, :order => 'created_on DESC', :conditions => ['user_id=?',@user.id])
    @uploads = Upload.find(:all, :order => 'created_on DESC', :conditions => ['user_id=?',@user.id])
    @pages = WikiPage.find(:all, :order => 'created_on DESC', :conditions => ['tool=? and user_id=?','Wiki', @user.id])
    @tabitems = []
    @tabitems << {:text => "General", :id => 'general'} 
    @tabitems << {:text => "Comments (#{@comments.size.to_s})", :id => 'discussion'} 
    @tabitems << {:text => "Changes (#{@versions.size.to_s})", :id => 'changes'} 
    @tabitems << {:text => "Uploads (#{@uploads.size.to_s})", :id => 'uploads'}     
    @tabitems << {:text => "New Pages (#{@pages.size.to_s})", :id => 'new_pages'}   
  end

  def account
    select_user
    #@version_pages, @versions = paginate :version, :per_page => 5, :order => 'created_on DESC', :conditions => ['user_id = ? and version <> 0', @user.id ]
  end
  
  def edit
    @user = User.find(params[:id])
    if request.get?
    else
      if  mine?(@user) || cadmin?
        if @user.update_attributes(params[:user].merge(:user => session['user']))
          flash.now['success'] = ::FLASH_RECORD_UPDATED
        end
      else
        flash.now['error'] = ::FLASH_NOT_OWNER        
      end
    end
  end
  
  def destroy
    #--
    # TODO Cannot destroy user with versions and comments, 
    # we should also do something with version and comments. Aassign versions 
    # and comments to admin user, and do a flash notice
    #++
    User.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
  
  def cadmin
    @cadmin = User.find(session['user'].id) # about to become 'ordinary' admin
    @user = User.find(params[:id]) # about to become cadmin
    User.cadmin(@cadmin,@user)
    flash['notice'] = FLASH_NO_LONGER_CADMIN 
    redirect_to :action => 'list'
  end
  
  def admin
    @user = User.find(params[:id])
    @user.user = session['user'] # used for authorisation
    @user.admin = params[:admin]
    if  @user.save
      flash['success'] = ::FLASH_RECORD_UPDATED
    end
    redirect_to :action => 'list'
  end    
  
  def toggle_change_report_notification
    @user = User.find(params[:user_id])
    if  mine?(@user) || cadmin?
      @user.notify_daily = (@user.notify_daily - 1).abs  if params[:type] == 'D'
      @user.notify_weekly = (@user.notify_weekly - 1).abs  if params[:type] == 'W'
      @user.notify_monthly = (@user.notify_monthly - 1).abs  if params[:type] == 'M'
      @user.notify_immediate = (@user.notify_immediate - 1).abs  if params[:type] == 'I'
      #user.notify_dialy = 1
      @user.save!
    end
    render :inline => "<%= link_to_change_report_notification_toggle(params[:type], @user) %>"
  end
  
  # Action #notification creates or deletes (toggles) a notification of a certain type for a Page and Site
  def notification
    @user = User.find(params[:user_id])
    @site = Site.find(params[:site_id])
    @page = Page.find(params[:page_id])
    @type = params[:notification_type]
    if session['user'] == @user || cadmin?
      n = Notification.find(:first, :conditions => ["user_id=? and page_id=? and notification_type=?", @user.id, @page.id, @type])
      if  n
        n.destroy
      else
        n = Notification.create(:user => session['user'], :page => @page, :notification_type => @type)
      end
      render :inline => "<%= link_to_notification_toggle(@page, @type, @user)%>"
    else
      render :inline => "<%= link_to_notification_toggle(@page, @type, @user)%>"
    end
  end
  
  def adminmessage
    @admin_message = AdminMessage.find(params[:id])
    if request.get?
    else
      @admin_message.update_attributes(params[:admin_message])
    end
  end
  
  protected
  def select_user #:doc:
    if params[:id]
      @user = User.find(params[:id])
    else
      @user = session['user']
    end
    if  !cadmin? && !mine?(@user)
      @user = session['user']
      flash['notice'] = LoginController::FLASH_UNOT_ADMIN 
    end
  end
  
end
