# The production environment is meant for finished, "live" apps.
# Code is not reloaded between requests
config.cache_classes = true

# Use a different logger for distributed setups
# config.logger        = SyslogLogger.new

# Full error reports are disabled and caching is turned on
config.action_controller.consider_all_requests_local = false
config.action_controller.perform_caching             = true

# Enable serving of images, stylesheets, and javascripts from an asset server
# config.action_controller.asset_host                  = "http://assets.example.com"

# Disable delivery errors if you bad email addresses should just be ignored
# config.action_mailer.raise_delivery_errors = false

ENV['EPFWIKI_APP_NAME'] = 'EPF Wiki'
ENV['EPFWIKI_PUBLIC_FOLDER'] = 'public'
ENV['EPFWIKI_EDITOR'] = 'tinymce' # TODO Bug 218832 - RTE
ENV['EPFWIKI_ROOT_DIR'] = File.expand_path(RAILS_ROOT) + '/'
ENV['EPFWIKI_HOST'] = "localhost" # used for jobs, when there is no host variable in the environment
ENV['EPFWIKI_SITES_FOLDER'] = 'bp'
ENV['EPFWIKI_SITES_PATH'] = ENV['EPFWIKI_ROOT_DIR'] + ENV['EPFWIKI_PUBLIC_FOLDER'] + '/' + ENV['EPFWIKI_SITES_FOLDER']
ENV['EPFWIKI_WIKIS_FOLDER'] = 'wikis' 
ENV['EPFWIKI_WIKIS_PATH'] = ENV['EPFWIKI_ROOT_DIR'] + ENV['EPFWIKI_PUBLIC_FOLDER'] + '/' + ENV['EPFWIKI_WIKIS_FOLDER']
ENV['EPFWIKI_DIFFS_PATH'] = ENV['EPFWIKI_ROOT_DIR'] + ENV['EPFWIKI_PUBLIC_FOLDER'] + "/#{RAILS_ENV}_diffs/"
#ENV['EPFWIKI_DOMAINS'] = "@epfwiki.org @openup.org" # specify to restrict valid emails to these domains. Uncomment to allow all.

ENV['EPFWIKI_REPLY_ADDRESS'] = "no-reply@epf.eclipse.org"
ENV['EPFWIKI_TEMPLATES_DIR'] = "#{ENV['EPFWIKI_ROOT_DIR']}#{ENV['EPFWIKI_PUBLIC_FOLDER']}/templates/"

ENV['EPFWIKI_GOOGLE_CUSTOM_SEARCH'] = 'N' # Google Custom Search example for EPFWiki.net

 # authentication methods that can be used to authenticate users
ENV['EPFWIKI_AUTH_METHODS'] = 'validemail' # valid values, for instance: bugzilla,basic,validemail
#ENV['EPFWIKI_AUTH_BASIC'] = 'home.global.logicacmg.com,401,logicacmg.com'  # host,fail code,domain for creating email
#ENV['EPFWIKI_AUTH_BUGZILLA'] = 'bugs.eclipse.org,443'  # host,port

ActionMailer::Base.delivery_method = :sendmail

#ActionMailer::Base.smtp_settings = {
#  :address  => 'mail.eclipse.org',
#  :port  => 25 , 
#  :domain  => 'epf.eclipse.org'#,
  #:user_name  => ,
  #:password  => ,
  #:authentication  => :login
#} 

