require File.dirname(__FILE__) + '/../test_helper'
require 'feedbacks_controller'

#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class FeedbacksController; def rescue_action(e) raise e end; end

class FeedbacksControllerTest < Test::Unit::TestCase

  fixtures :users

  def setup
    logger.debug "Test Case: #{name}"  
    @controller = FeedbacksController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new
    @andy = users(:andy) # admin
    @george = users(:george) # central admin
    @tony = users(:tony) # user
    @emails = ActionMailer::Base::deliveries
    @emails.clear
  end

  def test_edit
    get :edit, :id => 999
    assert_unot_cadmin_message
  end

  def test_destroy
    feedback = Feedback.create(:email => 'x@adb.com',:text => 'test_show')
    get :index
    session['user'] = @andy
    assert_nothing_raised {Feedback.find(feedback.id)}

    post :destroy, :id => feedback.id
    assert_unot_cadmin_message
    
    # TODO cannot test this because the controller uses request.referer
    #session['user'] = @george
    #post :destroy, :id => feedback.id
    
    #assert_response :redirect
    #assert_redirected_to :action => 'list'

    #assert_raise(ActiveRecord::RecordNotFound) {Feedback.find(feedback.id)}
  end
end
