require File.dirname(__FILE__) + '/../test_helper'
require 'other_controller'

#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class OtherController; def rescue_action(e) raise e end; end

class OtherControllerTest < Test::Unit::TestCase

  fixtures :users
  
  def setup
    logger.debug "Test Case: #{name}"  
    @controller = OtherController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new
    #@oup_20060721 = create_oup_20060721
    #@oup_20060728 = create_oup_20060728
    #@oup_wiki = create_oup_wiki(@oup_20060721)
    @andy = users(:andy) # admin
    @george = users(:george) # central admin
    @tony = users(:tony) # user
    @cash = users(:cash) 
  end
  
  def teardown
    [ENV['EPFWIKI_SITES_PATH'], ENV['EPFWIKI_WIKIS_PATH']].each do |p|
      FileUtils.rm_r(p) if File.exists?(p)
      File.makedirs(p)
    end
  end  

  # Shows all users can access information about the application with other/about
  def test_about
    get :about
    assert_response :success
  end
  
end
