require File.dirname(__FILE__) + '/../test_helper'
require 'uploads_controller'

#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class UploadsController; def rescue_action(e) raise e end; end

class UploadsControllerTest < Test::Unit::TestCase

  fixtures :users
  
  def setup
    logger.debug "Test Case: #{name}"  
    @controller = UploadsController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new
    @andy = users(:andy) # admin
    @george = users(:george) # central admin
    @tony = users(:tony) # user
  end
  
  # Shows:
  # 1. Logon
  # 2. Logged in user can upload image
  # 4. User cannot update upload of another user
  # 5. Admin can update upload of another user
  # 6. Admin cannot destroy upload of another user
  # 7. User cannot destroy own upload
  # 8. Cadmin can destroy upload of another user
  def test_new
    assert_equal 0, Upload.count
    # 1
    post :new
    assert_redirected_to :controller => 'login'
    # 2
    session['user'] = @andy
    post :new, :upload => {:upload_type => 'Image', :description => 'OpenUP PT image', :file => upload_file("#{ENV['EPFWIKI_ROOT_DIR']}test/functional/uploads_controller_test/openup_pt.jpg", 'image/jpeg')}
    assert_redirected_to :action => 'list'
    assert_equal 1, Upload.count
    assert_not_nil assigns(:upload)
    assert File.exists?(assigns(:upload).path)

    # 4
    get :index
    session['user'] = @tony
    upload = Upload.find(:first)
    post :update, :id => upload.id, :upload => {:description => 'image'}
    assert_equal ::FLASH_NOT_OWNER, flash['error']
    upload.reload
    assert_equal 'OpenUP PT image', upload.description
    # 5
    upload.user = @tony
    assert upload.save
    session['user'] = @andy
    post :update, :id => upload.id, :upload => {:description => 'image'}
    assert_equal nil, flash['error']
    upload.reload
    assert_equal 'image', upload.description
    # 6
    get :index
    session['user'] = @andy
    upload = Upload.find(:first)
    assert session['user'] != upload.user
    post :destroy, :id => upload
    assert_equal LoginController::FLASH_UNOT_CADMIN, flash['error']
    assert Upload.exists?(upload.id)
    upload2 = Upload.new(:filename => upload.filename, :upload_type => upload.upload_type, 
    :content_type => upload.content_type, :description => upload.description, 
    :user_id => upload.user_id, :rel_path => upload.rel_path)
    assert upload2.save
    # 7
    session['user'] = @tony
    assert session['user'], upload.user
    post :destroy, :id => upload
    assert Upload.exists?(upload)
    # 8 # TODO test this, currently we cannot test this because use of request.referer causes errors: "The error occurred while evaluating nil.[]"
    #session['user'] = @george
    #assert session['user'], upload2.user
    #post :destroy, :id => upload2
    #assert !Upload.exists?(upload2)
    #assert_equal 0, Upload.count    
  end
  
end
