require File.dirname(__FILE__) + '/../test_helper'

#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class UserTest < Test::Unit::TestCase
  
  fixtures :users
  
  def setup
    logger.debug "Test Case: #{name}"  
    @oup_20060721 = create_oup_20060721
    @oup_wiki = create_oup_wiki(@oup_20060721)
    @andy = users(:andy)
    @george = users(:george)
    @tony = users(:tony)
    @cash = users(:cash)
  end
  
  # TODO include all record types: 
  def test01_deliver_summary
    assert_not_nil @oup_wiki
    page = WikiPage.find_by_filename('artifact,_fdRfkBUJEdqrUt4zetC1gg.html')
    assert_not_nil page
    #date_previous_week = date - 7.days
    #puts "Previous week: #{date_previous_week}"
    #start_of_previous_week = (date - 7.days).at_beginning_of_week
    #start_of_week = date.at_beginning_of_week
    #puts "Previous week: from #{start_of_previous_week} to #{start_of_week}"
    #puts "Previous day from #{(Time.now - 1.day).at_beginning_of_day} to #{Time.now.at_beginning_of_day}"
    #puts "Previous month #{(Time.now - 1.month).at_beginning_of_month} to #{Time.now.at_beginning_of_month}"
    comment1 = Comment.new(:user => @andy, :text => 'some text', :page => page, :site => @oup_wiki, :version => page.versions[0])
    comment1.created_on = Time.now - 3.days
    assert comment1.save!
    page = WikiPage.find_by_filename('artifact,_fdRfkBUJEdqrUt4zetC1gg.html')
    checkout = Checkout.new(:user => @andy, :page => page, :site => @oup_wiki, :note => 'Checkout to test notifier')
    assert checkout.save! 
    assert Checkout.count > 0
    assert Comment.count > 0
    starttime = Time.now.at_beginning_of_month
    endtime = (Time.now + 1.month).at_beginning_of_month
    @tony.created_on = Time.now - 3.days
    @tony.save!
    assert 0 < User.find(:all, :conditions => ['created_on > ? and created_on < ?', starttime, endtime ], :order => 'created_on DESC').size
    Notifier::deliver_summary({:type => 'M', :dummy => ''}, Time.now + 1.month) # plus 1 month, because records are created in the current month
  end
  
end