require File.dirname(__FILE__) + '/../test_helper'

#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class VersionTest < Test::Unit::TestCase
  
  fixtures :users #, :checkouts, :versions
  
  def setup
    logger.debug "Test Case: #{name}"  
    @oup_20060721 = create_oup_20060721
    @oup_wiki = create_oup_wiki(@oup_20060721)
    @oup_20060728 = create_oup_20060728 
    @oup_20060825 = create_oup_20060825
    @andy = users(:andy) 
    @tony = users(:tony) 
    @cash = users(:cash) 
    @emails = ActionMailer::Base::deliveries
    @emails.clear
  end

  # Shows:
  # 1. We cannot checkout to baseline process, only to a Wiki
  # 2. We cannot write the html from a BaselineProcessVersion
  # 4. The path of a BaselineProcessVersion is just the path of the Page
  def test_various
    # 1
    assert_equal [0, 617], [UserVersion.count, BaselineProcessVersion.count]
    page = WikiPage.find(:first, :conditions => ['filename = ? and site_id = ?','test_data,_0ZZFcMlgEdmt3adZL5Dmdw.html', @oup_wiki])
    page.reload
    assert_equal 1, page.versions.size
    assert_equal 0, page.current_version.version
    co = Checkout.new(:user => @andy, :page => page, :site => @oup_20060825, :source_version => page.current_version)
    assert_raise(RuntimeError) {co.save}
    # 2
    assert_raise(NoMethodError) {page.current_version.html = 'version3 from @oup_wiki'}
    # 3
    page = WikiPage.find_by_filename('test_data,_0ZZFcMlgEdmt3adZL5Dmdw.html')
    assert_not_nil page
    version = page.current_version
    assert_equal 0, version.version
    bp_page = BaselineProcessPage.find_by_filename('test_data,_0ZZFcMlgEdmt3adZL5Dmdw.html')
    assert_equal bp_page.path, version.path
  end
  
  # Shows:
  # 1. The first version (version 0) does not have a previous_version
  # 2. We create version 1: previous_version is equal to the first version
  # 3. We create version 2 which has some added text 
  # 4. We can rollback changes by creating version 3 based on version 1
  # 5. Shows we can make a version 'current'
  # 6. Checkout doesn't change the 'current' version but checkin does
  def test_various_2
    page = WikiPage.find_by_filename('implementation,_0TeDoMlgEdmt3adZL5Dmdw.html')
    page.reload
    assert_not_nil page.versions
    assert File.exists?(page.path)
    cv0 = page.current_version
    assert_equal BaselineProcessVersion.name, cv0.class.name
    assert_equal 0, cv0.version 
    # 1
    assert_equal nil, cv0.previous_version 
    # 2
    # creating a new version
    co = Checkout.new(:user => @andy, :page => page, :site => @oup_wiki, :source_version => cv0)
    assert co.save
    co.checkin(@andy)
    cv1 = page.current_version
    assert_equal 1, cv1.version
    assert_equal cv1.previous_version, cv0
    # 3
    co = Checkout.new(:user => @andy, :page => page, :site => @oup_wiki, :source_version => cv1)
    assert co.save
    cv2 = co.version
    assert_nil cv2.version # number is determined on checkin
    cv2.html = cv2.html.gsub('</body>', '####</body>')
    co.checkin(@andy)
    cv2.reload
    assert_equal 2, cv2.version
    assert page.html.include?('####')
    # 4
    co = Checkout.new(:user => @andy, :page => page, :site => @oup_wiki, :source_version => cv1)
    assert co.save
    cv3 = co.version
    h = cv3.html
    assert_not_nil h
    assert !h.include?('####')
    co.checkin(@andy)
    cv3.reload
    assert_equal 3, cv3.version
    assert_equal cv3, page.current_version
    assert !page.html.include?('####')
    # 5
    assert_equal page.current_version, page.last_version # because there is no checkout
    page.current_version = cv1 
    assert_equal cv1, page.current_version
    page.current_version = cv2
    assert_equal cv2, page.current_version
    cv2.current = false 
    assert cv2.save
    assert cv2 != page.current_version
    assert_equal cv3, page.current_version
    # 6
    page.current_version = cv1 # we make cv1 current
    co = Checkout.new(:user => @andy, :page => page, :site => @oup_wiki, :source_version => cv3)
    assert co.save
    cv4 = co.version
    assert_equal cv1, page.current_version
    co.checkin(@andy)
    cv4.reload
    assert_equal cv4, page.current_version
    assert_equal cv4, page.last_version
    assert page.current_version.current.nil?
  end
  
  def test_xhtmldiff_diff_links
    page = WikiPage.find_by_filename('implementation,_0TeDoMlgEdmt3adZL5Dmdw.html') 
    # setup the page html
    page_html = IO.readlines(File.expand_path("test/unit/version_test/xp_environment,3.754748120034442E-307.html", RAILS_ROOT)).join
    page.html = page_html
    for i in 1..3
      co = Checkout.new(:user => @andy, :page => page, :site => @oup_wiki, :source_version => page.current_version)
      assert co.save
      assert_equal nil, co.version.version
      co.checkin(@andy)
      cv = page.current_version
      assert_equal i, cv.version
      assert_not_nil cv.page_id
    end
    page.reload
    assert_equal 4, page.versions.size
    html0 = IO.readlines(File.expand_path("test/unit/version_test/xp_environment,3.754748120034442E-307.html_EPFWIKI_BL2_v0.html", RAILS_ROOT)).join
    html1 = IO.readlines(File.expand_path("test/unit/version_test/xp_environment,3.754748120034442E-307.html_EPFWIKI_BL2_v1.html", RAILS_ROOT)).join
    html2 = IO.readlines(File.expand_path("test/unit/version_test/xp_environment,3.754748120034442E-307.html_EPFWIKI_BL2_v2.html", RAILS_ROOT)).join 
    version1 = page.versions[1]
    version2 = page.versions[2]
    version3 = page.versions[3]
    assert_equal [1,2,3],[version1.version, version2.version, version3.version]
    version1.html = html0
    version2.html = html1
    version3.html = html2
    assert_equal 0, @emails.size
    [[version2,version1],[version3,version2]].each do |versions|
      versions[0].xhtmldiffpage(versions[1])
      assert_equal "#{versions[0].relpath_to_diff(versions[1])} generated 0 email", "#{versions[0].relpath_to_diff(versions[1])} generated #{@emails.size} email"      
    end
    html3 = IO.readlines(File.expand_path("test/unit/version_test/architect.html_EPFWIKI_BL1_v0.html", RAILS_ROOT)).join 
    html4 = IO.readlines(File.expand_path("test/unit/version_test/architect.html_EPFWIKI_BL1_v1.html", RAILS_ROOT)).join     
    version4 = page.versions[1]
    version5 = page.versions[2]
    version4.html = html3
    version5.html = html4
    version5.xhtmldiffpage(version4)
    page = WikiPage.find_by_filename('implementation,_0TeDoMlgEdmt3adZL5Dmdw.html')
    versions = []
    versions << ['xp_programmer.html_EPFWIKI_BL2_v0.html', page.versions[1], '']
    versions << ['xp_programmer.html_EPFWIKI_BL2_v1.html', page.versions[2], '']
    versions.each do |v|
      v[2] = v[1].html # save the html, so we can rollback changes
      v[1].html = IO.readlines(File.expand_path("test/unit/version_test/#{v[0]}", RAILS_ROOT)).join
    end
    #links  = versions[0][1].diff_links(versions[1][1])  # new, removed
    #assert_equal [["href=\"./../../xp/guidances/concepts/coding_standard,8.8116853923311E-307.html\""],
    #["href=\"http://www.demo.epfwiki.net/wikis/openup/openup_basic/customcategories/resources/GetStarted_48.gif\""]], 
    #links
  end
  
  # TODO (but now now) note part of it is in the previous test
  # def test11_diff_links
  # end

end
