#--######################################################################
# Copyright (c) 2006 Logica
# Copyright (c) 2008 IBM
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
# Ricardo Balduino:: added mappings to handle Practice feed and UMA Types feed
#++######################################################################
# {Copyright (c) 2006 Logica, 2008 IBM}[link:files/COPYRIGHT.html]

ActionController::Routing::Routes.draw do |map|
  # The priority is based upon order of creation: first created -> highest priority.
  
  # Sample of regular route:
  # map.connect 'products/:id', :controller => 'catalog', :action => 'view'
  # Keep in mind you can assign values other than :controller and :action
  
  # Sample of named route:
  # map.purchase 'products/:id/purchase', :controller => 'catalog', :action => 'purchase'
  # This route can be invoked with purchase_url(:id => product.id)
  
  # You can have the root of your site routed by hooking up '' 
  # -- just remember to delete public/index.html.
  # map.connect '', :controller => "welcome"
  
  # Allow downloading Web Service WSDL as a file with an extension
  # instead of a file named 'wsdl'
  map.connect ':controller/service.wsdl', :action => 'wsdl'
  
  # Install the default route as the lowest priority.
  map.connect 'archives/:year/:month' ,
  :controller => 'portal' ,
  :action => 'archives' ,
#  :year => Time.now.year,
 # :month => Time.now.month,
  :requirements => {
  :year => /\d+/,
  :month => /\d+/
  }
  
  # author - RB
  # A route for generating feed for a given practice from a given wiki site.
  # http://myepfwiki/rss/[wiki folder]/practice/[practice_name]  
  # for example "http://epf.eclipse.org/rss/EPF_Practices/practice/iterative_development" returns a feed with all elements of Iterative Development practice found in the EPF_Practices Wiki
  map.connect "rss/:site_folder/practice/:practice_name",
    :controller => 'rss',
    :action => 'practice_feed',
    :requirements => {:site_folder => /.*/,
                      :practice_name => /.*/}

  # author - RB
  # A route for generating feed for all elements of a given uma_type found in a given wiki site.
  # http://myepfwiki/rss/[wiki folder]/[uma_type]  
  # for example "http://epf.eclipse.org/rss/EPF_Practices/practice" returns a feed with all practices in the EPF Practices Wiki
  map.connect "rss/:site_folder/:uma_type",
    :controller => 'rss',
    :action => 'any_uma_type_feed',
    :requirements => {:site_folder => /.*/,
                      :uma_type => /.*/}


# TODO implement
#  map.connect 'pages/list/:type',
#    :controller => 'pages',
#    :action => 'list',
#    :requirements => {:type => /\D+/}

  map.connect 'rss/:site_folder',
    :controller => 'rss',
    :action => 'list',
    :requirements => {:site_folder => /.*/}
  map.connect ':controller/:action/:id.:format'
  map.connect ':controller/:action/:id'
  # TODO evaluate this
  map.connect ':site_folder/:id/:action',
    :controller => 'pages'
  map.connect '', :controller => 'portal', :action => 'home', :title => 'Welcome'

  # See http://rambleon.org/2007/03/07/rails-12-route-changes-are-a-pain-in-the-arse/
  # The following made sense for Apache, but not for LiteSpeed. 
  # BTW, LiteSpeed can be configured to use a custom error page
  map.connect '*path', :controller => 'other', :action => 'show404', :requirements => { :path => /.*/ }


end
