#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class ReviewController < ApplicationController
  
  before_filter :authenticate_admin
  before_filter :find_record
  
  # Action #toggle_done toggles the <tt>done</tt> column. 
  def toggle_done
    if @record.reviewer.nil? || @record.reviewer == session['user'] || cadmin?
      if @record.done == 'Y'
        @record.update_attributes(:done => 'N')
      else
        @record.update_attributes(:done => 'Y')
      end
      render :inline => "<%= link_to_done_toggle(@record) %>"
    else
      render :inline => "<script language=\"JavaScript\">alert('To change the done flag you need to be the reviewer or the central administrator (#{User.find_central_admin.name})!')</script><%= link_to_done_toggle(@record) %>"
    end
  end
  
  #Action #review assigns current User as the reviewer
  def assign
    html = "<%= link_to_reviewer(@record) %>"
    if @record.reviewer.nil?
        @record.update_attributes(:reviewer => session['user'])
    elsif @record.reviewer == session['user']
        @record.update_attributes(:reviewer => nil)
    elsif cadmin?
        @record.update_attributes(:reviewer => session['user'])
    elsif !@record.reviewer.nil? && !cadmin?
        html = "<script language=\"JavaScript\">alert('Only the central administrator (#{User.find_central_admin.name}) can change or clear the reviewer!')</script><%= link_to_reviewer(@record) %>"
    end
    render :inline => html
  end
  
  # Action #review_note updates the review note
  def note
    @record.review_note = params[:value]
    @record.save! if @record.reviewer.nil? || @record.reviewer == session['user'] || cadmin?
    # html = "<script language=\"JavaScript\">alert('Only the central administrator (#{User.find_central_admin.name}) or the reviewer can update the review note!')</script>#{html}"      
    # It is not possible to display a alert when using in-place edit?
    @record.reload
    @record.review_note = '_______' if @record.review_note.blank?
    render :text => @record.review_note
  end
  
  #######
  private
  #######
  
  def find_record
    logger.debug("Find record using params: #{params.inspect}")
    case params['class_name'] 
    when 'Version' then @record = Version.find(params[:id])
    when 'UserVersion' then @record = Version.find(params[:id])
    when 'BaselineProcessProcessVersion' then @record = Version.find(params[:id])
    when 'Upload' then @record = Upload.find(params[:id])
    else @record = DaText.find(params[:id])
    end
  end
end