#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class RssController < ApplicationController

  session :off # stateless RSS requests
  
  caches_page :list 
  
  def list
    @cadmin = User.find_central_admin
    @updates = Update.find(:all, :order => 'finished_on DESC', :conditions => ['finished_on > ?', Time.now - 14.days], :limit => 14)
    @uploads = Upload.find(:all, :order => 'created_on DESC', :conditions => ['created_on > ?', Time.now - 14.days], :limit => 14)
    unless params[:site_folder] == 'all' then
      @wiki = Wiki.find_by_folder(params[:site_folder])
      @versions = Version.find(:all, :order => 'created_on DESC', :conditions => ['wiki_id=? and baseline_process_id is null and created_on > ? and not exists (select * from checkouts c where c.version_id=versions.id)', @wiki.id, Time.now - 14.days ], :limit => 14)
      @comments = Comment.find(:all, :order => 'created_on DESC', :conditions => ['site_id=? and created_on > ?', @wiki.id, Time.now - 14.days], :limit => 14)
    else
      @versions = Version.find(:all, :order => 'created_on DESC', :conditions => ['baseline_process_id is null and created_on > ? and not exists (select * from checkouts c where c.version_id=versions.id)',Time.now - 14.days], :limit => 14)
      @comments = Comment.find(:all, :order => 'created_on DESC', :conditions => ['created_on > ?',Time.now - 14.days], :limit => 14)
    end if
    headers['Content-Type'] = 'application/rss+xml'
    render :layout => false
  end
end