#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class Comment < DaText

    belongs_to :site 
    belongs_to :user 
    belongs_to :page
    belongs_to :version 

    validates_presence_of :text, :user, :page, :site, :version

    # Set some redundant properties
    #--
    # TODO remove these redundant properties
    #++
    def before_validation_on_create 
      if self.version.nil?
        if self.page.current_version
          self.version = self.page.current_version 
        end
      end
      unless self.version.nil?
        self.page = self.version.page 
     end
     self.site = self.page.site
    end

    def validate_on_create
      if self.version.nil?
        errors.add("Cannot comment on new pages that are in the process of being created (not checked in yet). Comments would be left dangling on undo checkout.")       
      end
    end
    
    def after_create
      Notification.find_or_create(self.page, self.user, Page.name)
    end

end