    # The test environment is used exclusively to run your application's
# test suite.  You never need to work with it otherwise.  Remember that
# your test database is "scratch space" for the test suite and is wiped
# and recreated between test runs.  Don't rely on the data there!
config.cache_classes = true

# Log error messages when you accidentally call methods on nil.
config.whiny_nils    = true

# Show full error reports and disable caching
config.action_controller.consider_all_requests_local = true
config.action_controller.perform_caching             = false

# Tell ActionMailer not to deliver emails to the real world.
# The :test delivery method accumulates sent emails in the
# ActionMailer::Base.deliveries array.
config.action_mailer.delivery_method = :test

# Overwrite the default settings for fixtures in tests. See Fixtures 
# for more details about these settings.
# config.transactional_fixtures = true
# config.instantiated_fixtures = false
# config.pre_loaded_fixtures = false

ENV['EPFWIKI_APP_NAME'] = "EPF Wiki - Test Enviroment"
ENV['EPFWIKI_PUBLIC_FOLDER'] = 'public'
ENV['EPFWIKI_EDITOR'] = 'tinymce' # TODO Bug 218832 - RTE
ENV['EPFWIKI_ROOT_DIR'] = File.expand_path(RAILS_ROOT) + '/'
ENV['EPFWIKI_HOST'] = "localhost:3000" # used for jobs, when there is no host variable in the environment
ENV['EPFWIKI_SITES_FOLDER'] = 'test_sites'
ENV['EPFWIKI_SITES_PATH'] = ENV['EPFWIKI_ROOT_DIR'] + ENV['EPFWIKI_PUBLIC_FOLDER'] + '/' + ENV['EPFWIKI_SITES_FOLDER']
ENV['EPFWIKI_WIKIS_FOLDER'] = 'test_wikis'
ENV['EPFWIKI_WIKIS_PATH'] = ENV['EPFWIKI_ROOT_DIR'] + ENV['EPFWIKI_PUBLIC_FOLDER'] + '/' + ENV['EPFWIKI_WIKIS_FOLDER']
ENV['EPFWIKI_DIFFS_PATH'] = ENV['EPFWIKI_ROOT_DIR'] + ENV['EPFWIKI_PUBLIC_FOLDER'] + "/#{RAILS_ENV}_diffs/"
ENV['EPFWIKI_DOMAINS'] = "@epf.eclipse.org @openup.org" # specify to restrict valid emails to these domains. Uncomment to allow all.
ENV['EPFWIKI_GENERATE_PASSWORDS'] = '0' # 1 to generate passwords or 0 to allow user to specify the password
ENV['EPFWIKI_REPLY_ADDRESS'] = "no-reply@epfwiki.org"
ENV['EPFWIKI_TEMPLATES_DIR'] = "#{ENV['EPFWIKI_ROOT_DIR']}#{ENV['EPFWIKI_PUBLIC_FOLDER']}/templates/"
ENV['EPFWIKI_OS'] = 'Windows' # 'Linux'

ENV['EPFWIKI_GOOGLE_CUSTOM_SEARCH'] = 'N' # Google Custom Search example for EPFWiki.net

 # authentication methods that can be used to authenticate users
ENV['EPFWIKI_AUTH_METHODS'] = 'validemail' # valid values, for instance: bugzilla,basic,validemail
#ENV['EPFWIKI_AUTH_BASIC'] = 'home.global.logicacmg.com,401,logicacmg.com'  # host,fail code,domain for creating email
ENV['EPFWIKI_AUTH_BUGZILLA'] = 'bugs.eclipse.org,443'  # host,port

ActionMailer::Base.smtp_settings = {
  :address  => 'epfwiki.org',
  :port  => 25, 
  #:domain  => ,
  #:user_name  => ,
  #:password  => ,
  #:authentication  => :login
} 

