//------------------------------------------------------------------------------
// Copyright (c) 2008 Logica and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
// 
// Contributors:
// Onno van der Straaten - initial implementation
//------------------------------------------------------------------------------
tinyMCE.importPluginLanguagePack('epfwiki');

var TinyMCE_epfwikiPlugin = {
	getInfo : function() {
		return {
			longname : 'EPF Wiki',
			author : 'Onno van der Straaten',
			authorurl : 'http://www.eclipse.org/epf',
			infourl : 'http://www.eclipse.org/epf',
			version : tinyMCE.majorVersion + "." + tinyMCE.minorVersion
		};
	},


	/**
	 * Returns the HTML contents of the save control.
	 */
	getControlHTML : function(cn) {
		switch (cn) {
			case "save":
				return tinyMCE.getButtonHTML(cn, 'lang_save_desc', '{$pluginurl}/images/save.gif', 'epfwikiSave');
			case "checkin":
				return tinyMCE.getButtonHTML(cn, 'lang_checkin_desc', '{$pluginurl}/images/checkin.gif', 'epfwikiCheckin');
			case "undocheckout":
				return tinyMCE.getButtonHTML(cn, 'lang_undocheckout_desc', '{$pluginurl}/images/undocheckout.gif', 'epfwikiUndoCheckout');
			case "preview":	
				return tinyMCE.getButtonHTML(cn, 'lang_preview_desc', '{$pluginurl}/images/preview.gif', 'epfwikiPreview');
		}

		return "";
	},

	/**
	 * Executes the save command.
	 */
	execCommand : function(editor_id, element, command, user_interface, value) {
		// Handle commands
		switch (command) {
			case "epfwikiPreview":
				var inst = tinyMCE.selectedInstance;
				var formObj = inst.formElement.form;
   				if (confirm('Save and preview the current document?.')) {  
   					//formObj.save.value = 'P'
					formObj.action = '/pages/preview';
  					inst.execCommand('epfwikiSave');
  				 }
				formObj.onsubmit;
				return true;
			case "epfwikiUndoCheckout":
				var inst = tinyMCE.selectedInstance;
				var formObj = inst.formElement.form;
   				if (confirm('Are you sure to want to undo the checkout? Any changes made to this version will be lost.')) {  
   					formObj.action = '/pages/undocheckout';
  					formObj.submit();
  				 }
				formObj.onsubmit;
				return true;
			case "epfwikiCheckin":
				var inst = tinyMCE.selectedInstance;
				var formObj = inst.formElement.form;
				if (confirm('Save and check-in the current document?')) {  
					formObj.action = '/pages/checkin';
					inst.execCommand('epfwikiSave');
				}
				return true;
			case "epfwikiSave":
				if (tinyMCE.getParam("fullscreen_is_enabled"))
					return true;

				var inst = tinyMCE.selectedInstance;
				var formObj = inst.formElement.form;

				if (tinyMCE.getParam("save_enablewhendirty") && !inst.isDirty())
					return true;

				if (formObj) {
					tinyMCE.triggerSave();

					// Use callback instead
					var os;
					if ((os = tinyMCE.getParam("save_onsavecallback"))) {
						if (eval(os + '(inst);')) {
							inst.startContent = tinyMCE.trim(inst.getBody().innerHTML);
							/*inst.undoLevels = new Array();
							inst.undoIndex = 0;
							inst.typingUndoIndex = -1;
							inst.undoRedo = true;
							inst.undoLevels[inst.undoLevels.length] = inst.startContent;*/
							tinyMCE.triggerNodeChange(false, true);
						}

						return true;
					}

					// Disable all UI form elements that TinyMCE created
					for (var i=0; i<formObj.elements.length; i++) {
						var elementId = formObj.elements[i].name ? formObj.elements[i].name : formObj.elements[i].id;

						if (elementId.indexOf('mce_editor_') == 0)
							formObj.elements[i].disabled = true;
					}

					tinyMCE.isNotDirty = true;

					if (formObj.onsubmit == null || formObj.onsubmit() != false)
						inst.formElement.form.submit();
				} else
					alert("Error: No form element found.");

				return true;
		}
		// Pass to next handler in chain
		return false;
	},

	handleNodeChange : function(editor_id, node, undo_index, undo_levels, visual_aid, any_selection) {
		if (tinyMCE.getParam("fullscreen_is_enabled")) {
			tinyMCE.switchClass(editor_id + '_save', 'mceButtonDisabled');
			return true;
		}

		if (tinyMCE.getParam("save_enablewhendirty")) {
			var inst = tinyMCE.getInstanceById(editor_id);

			if (inst.isDirty()) {
				tinyMCE.switchClass(editor_id + '_save', 'mceButtonNormal');
				return true;
			}

			tinyMCE.switchClass(editor_id + '_save', 'mceButtonDisabled');
		}

		return true;
	}
};

tinyMCE.addPlugin("epfwiki", TinyMCE_epfwikiPlugin);
