require File.dirname(__FILE__) + '/../test_helper'
require 'comments_controller'

#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class CommentsController; def rescue_action(e) raise e end; end

class CommentsControllerTest < Test::Unit::TestCase

  fixtures :users
  
  def setup
    logger.debug "Test Case: #{name}"  
    @controller = CommentsController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new
    @wiki = create_templates
    @andy, @george, @tony = users(:andy), users(:george), users(:tony) # admin, cadmin, user    
  end

  def teardown
    [ENV['EPFWIKI_SITES_PATH'], ENV['EPFWIKI_WIKIS_PATH']].each do |p|
      FileUtils.rm_r(p) if File.exists?(p)
      File.makedirs(p)
    end
  end
  
  # Shows:
  # 1. All users can access the edit form (including anonymous users)
  # 2. Cadmin can update and destroy
  def test_edit_update_destroy
    # 1
    p = WikiPage.find_by_presentation_name('Toolmentor Template')
    c = Comment.create(:text => 'Text of comment by user tony', :user => @tony, :version => p.current_version, :page => p, :site => p.site)
    get :edit, :id => c.id
    assert_response :success
    session['user'] = @andy
    get :edit, :id => c.id
    assert_response :success
    assert_match 'Text of comment by user tony', @response.body
    # 2
    post :destroy
    assert_unot_cadmin_message
    post :update
    assert_unot_cadmin_message
    session['user'] = @george
    post :destroy, :id => c.id 
    assert_redirected_to :controller => 'sites', :action => 'comments', :id => p.site.id
    # TODO test update
  end
  
end
