
require File.dirname(__FILE__) + '/../test_helper'
require 'rss_controller'
require 'feed_validator'

#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class RssController; def rescue_action(e) raise e end; end

class RssControllerTest < Test::Unit::TestCase

  fixtures :users
  
  def setup
    logger.debug "Test Case: #{name}"  
    @controller = RssController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new
    @andy, @george, @tony = users(:andy), users(:george), users(:tony) # admin, cadmin, user
  end

  def teardown
    [ENV['EPFWIKI_SITES_PATH'], ENV['EPFWIKI_WIKIS_PATH']].each do |p|
      FileUtils.rm_r(p) if File.exists?(p)
      File.makedirs(p)
    end
  end

  def test_list
    @wiki = create_templates
    p = WikiPage.find_by_presentation_name('Toolmentor Template')
    assert_not_nil p
    for i in 0..2
      c= Comment.new(:text => "Text of comment #{i} by user tony", :user => @tony, :version => p.current_version, :page => p, :site => p.site)
      assert c.save
      co = Checkout.new(:user => @andy, :page => p, :site => @wiki, :note => "Checkout #{i} by Andy")
      assert co.save
      co.checkin(@andy)
      u = Upload.new(:filename => 'filename.html', :upload_type => 'Image', 
        :content_type => 'Content type', :description => 'Description of upload', 
        :user_id => @andy.id, :rel_path => 'x/y/z.html')
      assert u.save
    end
    get :list, :site_folder => 'all'
    assert_valid_feed
    get :list, :site_folder => @wiki.folder
    assert_valid_feed
  end
  
  # Assumes you will have a development environment on http://localhost:3000 with some data
  #def test_development_with_feed_validator
  #  v = W3C::FeedValidator.new()
  #  v.validate_url('http://localhost:3000/rss/all') 
  #  puts v.to_s unless v.valid?
  #end
end
