require File.dirname(__FILE__) + '/../test_helper'
require 'versions_controller'
require 'pathname'

#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class VersionsController; def rescue_action(e) raise e end; end

class VersionsControllerTest < Test::Unit::TestCase

  fixtures :users
  
  def setup
    logger.debug "Test Case: #{name}"  
    @controller = VersionsController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new
    #@oup_20060721 = create_oup_20060721
    #@oup_wiki = create_oup_wiki(@oup_20060721)
    @andy = users(:andy) # admin
    @george = users(:george) # central admin
    @tony = users(:tony) # user
    @admin = users(:admin)
  end

  def teardown
    [ENV['EPFWIKI_SITES_PATH'], ENV['EPFWIKI_WIKIS_PATH']].each do |p|
      FileUtils.rm_r(p) if File.exists?(p)
      File.makedirs(p)
    end
  end
  
  # Shows
  # 1. Login required
  # 2. All users can access version details
  # 3. Get diif of equal versions
  # 4. Post diff of equal versions
  # 5. Post diff of versions with differences
    #show, diff, text, note
  def test_show_and_diff
    create_templates
    p = WikiPage.find(:first)
    create_some_data(p)
    # 1
    version = Version.find(:first)
    assert_not_nil version
    get :show, :id => version.id
    assert_tologin
    # 2
    [@andy, @george, @tony].each do |user|
      session['user'] = user
      Version.find(:all).each do |v|  
        get :show, :id => v.id
        # 2
        assert_response :success
        assert_not_nil assigns(:version)
      end
    end
    assert_equal 17, p.versions.size
    v1 = p.versions[14]
    v2 = p.versions[15]
    # 3
    get :diff, :id => v2.id
    assert_response :success
    assert_not_nil assigns(:version)
    assert_equal v1, assigns(:version).source_version
    assert_equal assigns(:versions), p.versions
    assert_equal p, assigns(:page)
    assert_equal p.site, assigns(:wiki)
    # 4
    post :diff, :version => {:id => v2.id, :version_id => v1.id}
    assert_response :success
    assert_equal assigns(:versions), p.versions
    assert_equal p, assigns(:page)
    assert_equal p.site, assigns(:wiki)
    # 5
    v2.html = v2.html.gsub('</body>','a change</body>')      
    post :diff, :version => {:id => v2.id, :version_id => v1.id}
    assert_response :success
    assert_equal assigns(:versions), p.versions
    assert_equal p, assigns(:page)
    assert_equal p.site, assigns(:wiki)
  end
  
end