require File.dirname(__FILE__) + '/../test_helper'

#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class CommentTest < Test::Unit::TestCase
  
  fixtures :users
  
  def setup
    logger.debug "Test Case: #{name}"  
    @andy = users(:andy)
    @cash = users(:cash)
  end
  
  # Shows that a user will start receiving notifications about page changes after creating a comment about a page
  def test_notification
    wiki = create_templates
    wiki.reload
    version = Version.find(:first)
    assert !Notification.find_all_users(version.page, Page.name).include?(@andy)
    Comment.create(:text => 'test', :user => @andy, :version => version, :page => version.page, :site => version.wiki)
    assert Notification.find_all_users(version.page, Page.name).include?(@andy)
    Comment.create(:text => 'another test', :user => @andy, :version => version, :page => version.page, :site => version.wiki)
    assert Notification.find_all_users(version.page, Page.name).include?(@andy)
    Comment.create(:text => 'another test', :user => @cash, :version => version, :page => version.page, :site => version.wiki)
    assert Notification.find_all_users(version.page, Page.name).include?(@cash)
  end
end
