require File.dirname(__FILE__) + '/../test_helper'

#--######################################################################
# Copyright (c) 2006 Logica
# 
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# 
# Onno van der Straaten:: initial implementation
#++######################################################################
# {Copyright (c) 2006 Logica}[link:files/COPYRIGHT.html]

class CopyrightTest < Test::Unit::TestCase
  
  def test01_rb_files
    files = copyright_files(File.expand_path(RAILS_ROOT) + '/app')
    files = files + copyright_files(File.expand_path(RAILS_ROOT) + '/db')
    files = files + copyright_files(File.expand_path(RAILS_ROOT) + '/lib')    
    files = files + copyright_files(File.expand_path(RAILS_ROOT) + '/test')  
    files = files - [File.expand_path(RAILS_ROOT) + '/db/schema.rb'] # generated file, not in svn
    files_without = []
    files.each do |file|
      content = IO.readlines(file).join
      logger.info('Content:' + content)
      if content =~ /#--(#){70}(\r\n|\n)# Copyright \(c\) 2006 Logica(\r\n|\n)# (\r\n|\n)# All(.)*epl-v10.html(\r\n|\n)#(\r\n|\n)# Contributors:(\r\n|\n)# (.)*#\+\+(#){70}(\r\n|\n)# \{(.)*files\/COPYRIGHT\.html\]/mi
      else
        files_without << file
      end
    end
    logger.info("Files without copyright notice #{files_without.size} from total #{files.size}")
    assert_equal [], files_without
  end
end
