# Openup
  
  def create_oup_version(folder)
    RAILS_DEFAULT_LOGGER.debug("Creating baseline #{folder}")
    bp = BaselineProcess.new(:folder => folder, :title => folder, :user_id => User.find_central_admin.id)    
    if File.exists?(bp.path)
      RAILS_DEFAULT_LOGGER.debug('Removing old folder')
      FileUtils.rm_r(bp.path)
    end
    if !File.exists?(bp.path2zip)
      path = File.expand_path(File.dirname(__FILE__) + "/../data/#{bp.folder}.zip")
      File.makedirs(File.dirname(bp.path2zip))
      RAILS_DEFAULT_LOGGER.debug("Copying #{path} to #{bp.path2zip}")
      File.copy(path, bp.path2zip) 
    end
    bp.unzip_upload
    bp.save!
    bp.scan4content
    return bp
  end
  
  def create_oup_20060721
    return create_oup_version('oup_20060721')
  end
  
  def create_oup_20060728
    return create_oup_version('oup_20060728')
  end
  
  def create_oup_20060825
    return create_oup_version('oup_20060825')
  end
  
  def create_oup_wiki(baseline = create_oup_20060721, folder = 'openup')
    RAILS_DEFAULT_LOGGER.debug('Creating OpenUP wiki')
    cadmin = User.find_central_admin
    wiki = Wiki.new(:folder => folder, :title => 'OpenUP Wiki', :user_id => cadmin.id) # , :baseline_process_id => baseline.id TODO cleanup
    if File.exists?(wiki.path)
      RAILS_DEFAULT_LOGGER.debug('Removing old folder')
      FileUtils.rm_r(wiki.path)
    end
    File.makedirs(File.dirname(wiki.path))
    wiki.save!
    update = Update.create(:wiki_id => wiki.id, :baseline_process_id => baseline.id, :user_id => cadmin.id)
    #wiki.wikify
    #wiki.save!
    update.do_update
    return wiki
  end
