# Templates
  
  def create_templates_baseline(folder = 'templates_20080828')
    RAILS_DEFAULT_LOGGER.debug("Creating baseline #{folder}")
    cadmin = User.find_central_admin
    bp = BaselineProcess.new(:folder => folder, :title => folder, :user_id => cadmin.id)
    if File.exists?(bp.path)
      RAILS_DEFAULT_LOGGER.debug('Removing old folder')
      FileUtils.rm_r(bp.path)
    end
    if !File.exists?(bp.path2zip)
      path = File.expand_path(File.dirname(__FILE__) + "/../data/#{bp.folder}.zip")
      File.makedirs(File.dirname(bp.path2zip))
      RAILS_DEFAULT_LOGGER.debug("Copying #{path} to #{bp.path2zip}")
      File.copy(path, bp.path2zip) 
    end
    bp.unzip_upload
    bp.save!
    bp.scan4content
    return bp
  end
  
  def create_templates(bp = create_templates_baseline, folder = 'templates')
    RAILS_DEFAULT_LOGGER.debug('Creating Templates Wiki')
    cadmin = User.find_central_admin
    wiki = Wiki.new(:folder => folder, :title => 'Templates', :user_id => cadmin.id)
    if File.exists?(wiki.path)
      RAILS_DEFAULT_LOGGER.debug('Removing old folder')
      FileUtils.rm_r(wiki.path)
    end
    File.makedirs(File.dirname(wiki.path))
    wiki.save!
    update = Update.create(:wiki_id => wiki.id, :baseline_process_id => bp.id, :user_id => cadmin.id)
    update.do_update
    return wiki
  end
  
