/*******************************************************************************
 * Copyright (c) 2011 The University of York.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Louis Rose - initial API and implementation
 ******************************************************************************/
package org.eclipse.epsilon.egl.engine.traceability.fine.trace;

import java.util.Arrays;
import java.util.Collection;

public class ModelLocation {

	public final Object modelElement;
	public final String propertyName;
	
	public ModelLocation(Object modelElement, String propertyName) {
		this.modelElement = modelElement;
		this.propertyName = propertyName;
	}
	
	
	// Getters for compatibility with JavaModel, which are used in acceptance tests

	public Object getModelElement() {
		return modelElement;
	}
	
	public String getPropertyName() {
		return propertyName;
	}

	public Collection<? extends Object> getAllContents() {
		return Arrays.asList(this, modelElement);
	}
}
