/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.spi.p2.artifact.repository;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.ECFTransport;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.artifact.repository.Transport;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryIO;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.spi.p2.artifact.repository.IArtifactRepositoryFactory;
import org.eclipse.osgi.util.NLS;

public class SimpleArtifactRepositoryFactory
implements IArtifactRepositoryFactory {
    public IArtifactRepository load(URL location, IProgressMonitor monitor) throws ProvisionException {
        long time = 0L;
        if (Tracing.DEBUG_METADATA_PARSING) {
            Tracing.debug((String)("Restoring artifact repository " + location));
            time = -System.currentTimeMillis();
        }
        File localFile = null;
        boolean local = false;
        try {
            SimpleArtifactRepository simpleArtifactRepository;
            block26: {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)300);
                OutputStream artifacts = null;
                boolean compress = true;
                if ("file".equals(location.getProtocol())) {
                    local = true;
                    localFile = new File(SimpleArtifactRepository.getActualLocation(location, true).getPath());
                    if (!localFile.exists()) {
                        localFile = new File(SimpleArtifactRepository.getActualLocation(location, false).getPath());
                        compress = false;
                    }
                } else {
                    localFile = File.createTempFile("artifacts", ".xml");
                    try {
                        artifacts = new BufferedOutputStream(new FileOutputStream(localFile));
                        IStatus status = this.getTransport().download(SimpleArtifactRepository.getActualLocation(location, compress).toExternalForm(), artifacts, (IProgressMonitor)sub.newChild(100));
                        if (!status.isOK()) {
                            compress = false;
                            status = this.getTransport().download(SimpleArtifactRepository.getActualLocation(location, compress).toExternalForm(), artifacts, (IProgressMonitor)sub.newChild(100));
                            if (!status.isOK()) {
                                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1000, status.getMessage(), null));
                            }
                        }
                    }
                    finally {
                        if (artifacts != null) {
                            artifacts.close();
                        }
                    }
                }
                FilterInputStream descriptorStream = null;
                try {
                    descriptorStream = new BufferedInputStream(new FileInputStream(localFile));
                    if (compress) {
                        URL actualFile = SimpleArtifactRepository.getActualLocation(location, false);
                        JarInputStream jInStream = new JarInputStream(descriptorStream);
                        JarEntry jarEntry = jInStream.getNextJarEntry();
                        String filename = new Path(actualFile.getFile()).lastSegment();
                        while (jarEntry != null && !filename.equals(jarEntry.getName())) {
                            jarEntry = jInStream.getNextJarEntry();
                        }
                        if (jarEntry == null) {
                            throw new FileNotFoundException("Repository not found in " + actualFile.getPath());
                        }
                        descriptorStream = jInStream;
                    }
                    SimpleArtifactRepositoryIO io = new SimpleArtifactRepositoryIO();
                    SimpleArtifactRepository result = (SimpleArtifactRepository)io.read(localFile.toURL(), descriptorStream, (IProgressMonitor)sub.newChild(100));
                    result.initializeAfterLoad(location);
                    if (Tracing.DEBUG_METADATA_PARSING) {
                        Tracing.debug((String)("Restoring artifact repository time (ms): " + (time += System.currentTimeMillis())));
                    }
                    simpleArtifactRepository = result;
                    if (descriptorStream == null) break block26;
                }
                catch (Throwable throwable) {
                    String msg;
                    try {
                        if (descriptorStream != null) {
                            ((InputStream)descriptorStream).close();
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        msg = NLS.bind((String)Messages.io_failedRead, (Object)location);
                        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1000, msg, (Throwable)e));
                    }
                    catch (IOException e) {
                        msg = NLS.bind((String)Messages.io_failedRead, (Object)location);
                        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1002, msg, (Throwable)e));
                    }
                }
                ((InputStream)descriptorStream).close();
            }
            return simpleArtifactRepository;
        }
        finally {
            if (!local && localFile != null && !localFile.delete()) {
                localFile.deleteOnExit();
            }
        }
    }

    public IArtifactRepository create(URL location, String name, String type, Map properties) {
        return new SimpleArtifactRepository(name, location, properties);
    }

    private Transport getTransport() {
        return ECFTransport.getInstance();
    }
}

