/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.director.Recommendation;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.osgi.service.resolver.VersionRange;

public class RecommendationDescriptor {
    public static final String TOUCHPOINT_DATA_KEY = "recommendations";
    public static final String KIND = "recommendation";
    private Set recommendations;

    public RecommendationDescriptor(Set recommendations) {
        this.recommendations = recommendations;
    }

    public Set getRecommendations() {
        return this.recommendations;
    }

    public Recommendation findRecommendation(RequiredCapability toMatch) {
        Iterator iterator = this.recommendations.iterator();
        while (iterator.hasNext()) {
            Recommendation name = (Recommendation)iterator.next();
            if (!name.matches(toMatch)) continue;
            return name;
        }
        return null;
    }

    public Recommendation findRecommendation(Recommendation toMatch) {
        Iterator iterator = this.recommendations.iterator();
        while (iterator.hasNext()) {
            Recommendation name = (Recommendation)iterator.next();
            if (!name.matches(toMatch)) continue;
            return name;
        }
        return null;
    }

    public IStatus merge(RecommendationDescriptor other) {
        MultiStatus result = null;
        Iterator it = other.recommendations.iterator();
        while (it.hasNext()) {
            Recommendation otherRecommendation = (Recommendation)it.next();
            Recommendation matchInThis = this.findRecommendation(otherRecommendation);
            if (matchInThis == null) {
                this.recommendations.add(otherRecommendation);
                continue;
            }
            Recommendation newRec = otherRecommendation.merge(matchInThis);
            if (newRec != null) {
                this.recommendations.remove(matchInThis);
                this.recommendations.add(newRec);
                continue;
            }
            if (result == null) {
                result = new MultiStatus("org.eclipse.equinox.p2.director", 0, "Conflict between recommendations", null);
            }
            result.add((IStatus)new Status(1, "org.eclipse.equinox.p2.director", "can't merge " + otherRecommendation + " with " + matchInThis));
        }
        if (result == null) {
            return Status.OK_STATUS;
        }
        return result;
    }

    public static RecommendationDescriptor parse(String descriptor) {
        StringTokenizer entries = new StringTokenizer(descriptor, "\n");
        HashSet<Recommendation> recommendations = new HashSet<Recommendation>(entries.countTokens());
        while (entries.hasMoreElements()) {
            StringTokenizer oneRec = new StringTokenizer((String)entries.nextElement(), "/");
            if (oneRec.countTokens() != 4) continue;
            String ns = oneRec.nextToken().trim();
            String name = oneRec.nextToken().trim();
            String oldRange = oneRec.nextToken().trim();
            String newRange = oneRec.nextToken().trim();
            recommendations.add(new Recommendation(MetadataFactory.createRequiredCapability((String)ns, (String)name, (VersionRange)new VersionRange(oldRange), null, (boolean)false, (boolean)false), MetadataFactory.createRequiredCapability((String)ns, (String)name, (VersionRange)new VersionRange(newRange), null, (boolean)false, (boolean)false)));
        }
        return new RecommendationDescriptor(recommendations);
    }

    public static String serialize(RecommendationDescriptor toSerialize) {
        StringBuffer result = new StringBuffer();
        Iterator iterator = toSerialize.recommendations.iterator();
        while (iterator.hasNext()) {
            Recommendation entry = (Recommendation)iterator.next();
            result.append(String.valueOf(entry.applyOn().getNamespace()) + '/' + entry.applyOn().getName() + '/' + entry.applyOn().getRange().toString() + '/' + entry.newValue().getRange().toString() + '\n');
        }
        return result.toString();
    }

    public boolean isCompatible(RecommendationDescriptor other) {
        Iterator it = other.recommendations.iterator();
        while (it.hasNext()) {
            Recommendation otherRecommendation = (Recommendation)it.next();
            Recommendation matchInThis = this.findRecommendation(otherRecommendation);
            if (matchInThis == null || otherRecommendation.isCompatible(matchInThis)) continue;
            return false;
        }
        return true;
    }
}

