/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.osgi.framework.BundleContext;

public class DownloadManager {
    private ProvisioningContext provContext = null;
    ArrayList requestsToProcess = new ArrayList();
    private static final String FILE_PROTOCOL = "file";
    private static final Comparator LOCAL_FIRST_COMPARATOR = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            Assert.isTrue((boolean)(arg0 instanceof URL));
            Assert.isTrue((boolean)(arg1 instanceof URL));
            String protocol0 = ((URL)arg0).getProtocol();
            String protocol1 = ((URL)arg1).getProtocol();
            if (protocol0.equals(DownloadManager.FILE_PROTOCOL) && !protocol1.equals(DownloadManager.FILE_PROTOCOL)) {
                return -1;
            }
            if (!protocol0.equals(DownloadManager.FILE_PROTOCOL) && protocol1.equals(DownloadManager.FILE_PROTOCOL)) {
                return 1;
            }
            return 0;
        }
    };
    static /* synthetic */ Class class$0;

    public DownloadManager(ProvisioningContext context) {
        this.provContext = context;
    }

    public void add(IArtifactRequest toAdd) {
        this.requestsToProcess.add(toAdd);
    }

    public void add(IArtifactRequest[] toAdd) {
        int i = 0;
        while (i < toAdd.length) {
            this.add(toAdd[i]);
            ++i;
        }
    }

    private void filterUnfetched() {
        Iterator iterator = this.requestsToProcess.iterator();
        while (iterator.hasNext()) {
            IArtifactRequest request = (IArtifactRequest)iterator.next();
            if (request.getResult() == null || !request.getResult().isOK()) continue;
            iterator.remove();
        }
    }

    public IStatus start(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.download_artifact, (int)this.requestsToProcess.size());
        try {
            if (this.requestsToProcess.isEmpty()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            BundleContext bundleContext = EngineActivator.getContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IArtifactRepositoryManager repoMgr = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
            URL[] repositories = null;
            repositories = this.provContext == null || this.provContext.getArtifactRepositories() == null ? repoMgr.getKnownRepositories(0) : this.provContext.getArtifactRepositories();
            if (repositories.length == 0) {
                Status status = new Status(4, "org.eclipse.equinox.p2.engine", Messages.download_no_repository);
                return status;
            }
            Arrays.sort(repositories, LOCAL_FIRST_COMPARATOR);
            this.fetch(repoMgr, repositories, subMonitor);
            IStatus iStatus = this.overallStatus(monitor);
            return iStatus;
        }
        finally {
            subMonitor.done();
        }
    }

    private void fetch(IArtifactRepositoryManager repoMgr, URL[] repositories, SubMonitor monitor) {
        int i = 0;
        while (i < repositories.length && !this.requestsToProcess.isEmpty() && !monitor.isCanceled()) {
            try {
                IArtifactRepository current = repoMgr.loadRepository(repositories[i], (IProgressMonitor)monitor.newChild(0));
                IArtifactRequest[] requests = this.getRequestsForRepository(current);
                IStatus dlStatus = current.getArtifacts(requests, (IProgressMonitor)monitor.newChild(requests.length));
                if (dlStatus.getSeverity() == 8) {
                    return;
                }
                this.filterUnfetched();
                monitor.setWorkRemaining(this.requestsToProcess.size());
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
    }

    private IArtifactRequest[] getRequestsForRepository(IArtifactRepository repository) {
        ArrayList<IArtifactRequest> applicable = new ArrayList<IArtifactRequest>();
        Iterator it = this.requestsToProcess.iterator();
        while (it.hasNext()) {
            IArtifactRequest request = (IArtifactRequest)it.next();
            if (!repository.contains(request.getArtifactKey())) continue;
            applicable.add(request);
        }
        return applicable.toArray(new IArtifactRequest[applicable.size()]);
    }

    private IStatus overallStatus(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.requestsToProcess.size() == 0) {
            return Status.OK_STATUS;
        }
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        Iterator iterator = this.requestsToProcess.iterator();
        while (iterator.hasNext()) {
            IStatus failed = ((IArtifactRequest)iterator.next()).getResult();
            if (failed == null || failed.isOK()) continue;
            result.add(failed);
        }
        return result;
    }
}

