/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.installer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.installer.VersionedName;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallDescription;

public class InstallDescriptionParser {
    private static final String PROP_AGENT_LOCATION = "eclipse.p2.agentLocation";
    private static final String PROP_ARTIFACT_REPOSITORY = "eclipse.p2.artifacts";
    private static final String PROP_BUNDLE_LOCATION = "eclipse.p2.bundleLocation";
    private static final String PROP_INSTALL_LOCATION = "eclipse.p2.installLocation";
    private static final String PROP_IS_AUTO_START = "eclipse.p2.autoStart";
    private static final String PROP_LAUNCHER_NAME = "eclipse.p2.launcherName";
    private static final String PROP_METADATA_REPOSITORY = "eclipse.p2.metadata";
    private static final String PROP_PROFILE_NAME = "eclipse.p2.profileName";
    private static final String PROP_ROOT_ID = "eclipse.p2.rootId";
    private static final String PROP_ROOT_VERSION = "eclipse.p2.rootVersion";
    private static final String PROP_ROOTS = "eclipse.p2.roots";

    public static InstallDescription createDescription(String site, SubMonitor monitor) throws IOException {
        InputStream in = null;
        if (site == null) {
            File file = new File("installer.properties").getAbsoluteFile();
            if (file.exists()) {
                in = new FileInputStream(file);
            }
        } else {
            in = new URL(site).openStream();
        }
        Properties properties = new Properties();
        try {
            if (in != null) {
                properties.load(in);
            }
        }
        finally {
            InstallDescriptionParser.safeClose(in);
        }
        InstallDescription result = new InstallDescription();
        result = InstallDescriptionParser.initiailize(result, properties);
        InstallDescriptionParser.initializeProfileProperties(result, properties);
        result = InstallDescriptionParser.initiailize(result, System.getProperties());
        return result;
    }

    private static InstallDescription initiailize(InstallDescription description, Properties properties) {
        String rootSpec;
        String id;
        String property = properties.getProperty(PROP_ARTIFACT_REPOSITORY);
        if (property != null) {
            description.setArtifactRepositories(InstallDescriptionParser.getURLs(property));
        }
        if ((property = properties.getProperty(PROP_METADATA_REPOSITORY)) != null) {
            description.setMetadataRepositories(InstallDescriptionParser.getURLs(property));
        }
        if ((property = properties.getProperty(PROP_IS_AUTO_START)) != null) {
            description.setAutoStart(Boolean.TRUE.toString().equalsIgnoreCase(property));
        }
        if ((property = properties.getProperty(PROP_LAUNCHER_NAME)) != null) {
            description.setLauncherName(property);
        }
        if ((property = properties.getProperty(PROP_INSTALL_LOCATION)) != null) {
            description.setInstallLocation((IPath)new Path(property));
        }
        if ((property = properties.getProperty(PROP_AGENT_LOCATION)) != null) {
            description.setAgentLocation((IPath)new Path(property));
        }
        if ((property = properties.getProperty(PROP_BUNDLE_LOCATION)) != null) {
            description.setBundleLocation((IPath)new Path(property));
        }
        if ((property = properties.getProperty(PROP_PROFILE_NAME)) != null) {
            description.setProductName(property);
        }
        if ((id = properties.getProperty(PROP_ROOT_ID)) != null) {
            String version = properties.getProperty(PROP_ROOT_VERSION);
            description.setRoots(new VersionedName[]{new VersionedName(id, version)});
        }
        if ((rootSpec = properties.getProperty(PROP_ROOTS)) != null) {
            String[] rootList = InstallDescriptionParser.getArrayFromString(rootSpec, ",");
            VersionedName[] roots = new VersionedName[rootList.length];
            int i = 0;
            while (i < rootList.length) {
                roots[i] = VersionedName.parse(rootList[i]);
                ++i;
            }
            description.setRoots(roots);
        }
        return description;
    }

    private static void initializeProfileProperties(InstallDescription description, Properties properties) {
        HashMap<Object, Object> profileProperties = new HashMap<Object, Object>(properties);
        profileProperties.remove(PROP_PROFILE_NAME);
        profileProperties.remove(PROP_ARTIFACT_REPOSITORY);
        profileProperties.remove(PROP_METADATA_REPOSITORY);
        profileProperties.remove(PROP_IS_AUTO_START);
        profileProperties.remove(PROP_LAUNCHER_NAME);
        profileProperties.remove(PROP_AGENT_LOCATION);
        profileProperties.remove(PROP_BUNDLE_LOCATION);
        profileProperties.remove(PROP_ROOT_ID);
        profileProperties.remove(PROP_ROOT_VERSION);
        profileProperties.remove(PROP_ROOTS);
        description.setProfileProperties(profileProperties);
    }

    private static URL[] getURLs(String spec) {
        if (spec == null) {
            return null;
        }
        String[] urlSpecs = InstallDescriptionParser.getArrayFromString(spec, ",");
        ArrayList<URL> result = new ArrayList<URL>(urlSpecs.length);
        int i = 0;
        while (i < urlSpecs.length) {
            try {
                result.add(new URL(urlSpecs[i]));
            }
            catch (MalformedURLException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.installer", "Invalid URL in install description: " + urlSpecs[i], (Throwable)e));
            }
            ++i;
        }
        return result.toArray(new URL[result.size()]);
    }

    private static void safeClose(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static String[] getArrayFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }
}

