/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.update;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class Utils {
    public static boolean isWindows = System.getProperty("os.name").startsWith("Win");
    private static boolean init = false;
    private static boolean useEnc = true;
    private static final String FILE_PROTOCOL = "file:";

    public static String decode(String s, String enc) throws UnsupportedEncodingException {
        if (!init) {
            init = true;
            try {
                return URLDecoder.decode(s, enc);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                useEnc = false;
            }
        }
        return useEnc ? URLDecoder.decode(s, enc) : URLDecoder.decode(s);
    }

    public static String canonicalizeURL(String url) {
        if (!isWindows || !url.startsWith(FILE_PROTOCOL)) {
            return url;
        }
        try {
            String path = new URL(url).getPath();
            File file = new File(path);
            path = file.toString().replace('\\', '/');
            if (path.length() == 0) {
                return url;
            }
            if (Character.isUpperCase(path.charAt(0))) {
                char[] chars = path.toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                path = new String(chars);
                return new File(path).toURL().toExternalForm();
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return url;
    }

    public static boolean equals(Object one, Object two) {
        return one == null ? two == null : one.equals(two);
    }

    public static boolean equals(Object[] one, Object[] two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one.length != two.length) {
            return false;
        }
        int i = 0;
        while (i < one.length) {
            boolean found = false;
            int j = 0;
            while (!found && j < two.length) {
                found = one[i].equals(two[j]);
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String makeRelative(String urlString, URL rootURL) {
        int index = urlString.indexOf(FILE_PROTOCOL);
        if (index == -1) {
            return urlString;
        }
        index += 5;
        boolean done = false;
        URL url = null;
        String file = urlString;
        while (!done) {
            try {
                url = new URL(file);
                file = url.getFile();
            }
            catch (MalformedURLException malformedURLException) {
                done = true;
            }
        }
        if (url == null || !new File(url.getFile()).isAbsolute()) {
            return urlString;
        }
        String rootString = rootURL.toExternalForm();
        return String.valueOf(urlString.substring(0, index)) + Utils.makeRelative(urlString.substring(index), rootString.substring(rootString.indexOf(FILE_PROTOCOL) + 5));
    }

    public static String makeRelative(String original, String rootPath) {
        Path path = new Path(original);
        if (!path.isAbsolute()) {
            return original;
        }
        String result = Utils.makeRelative((IPath)path, (IPath)new Path(rootPath));
        return path.toOSString().equals(result) ? original : result;
    }

    private static String makeRelative(IPath toRel, IPath base) {
        if (toRel.getDevice() != null && !toRel.getDevice().equalsIgnoreCase(base.getDevice())) {
            return toRel.toOSString();
        }
        int i = base.matchingFirstSegments(toRel);
        if (i == 0) {
            return toRel.toOSString();
        }
        String result = "";
        int j = 0;
        while (j < base.segmentCount() - i) {
            result = String.valueOf(result) + "../";
            ++j;
        }
        if (i == toRel.segmentCount()) {
            return ".";
        }
        result = String.valueOf(result) + toRel.setDevice(null).removeFirstSegments(i).toOSString();
        return result;
    }

    public static String makeAbsolute(String original, String rootPath) {
        Path path = new Path(original);
        if (path.isAbsolute()) {
            return original;
        }
        Path root = new Path(rootPath);
        return root.addTrailingSeparator().append(original.replace(':', '}')).toOSString().replace('}', ':');
    }

    public static String makeAbsolute(String urlString, URL rootURL) {
        int index = urlString.indexOf(FILE_PROTOCOL);
        if (index == -1) {
            return urlString;
        }
        index += 5;
        boolean done = false;
        URL url = null;
        String file = urlString;
        while (!done) {
            try {
                url = new URL(file);
                file = url.getFile();
            }
            catch (MalformedURLException malformedURLException) {
                done = true;
            }
        }
        if (url == null || new File(url.getFile()).isAbsolute()) {
            return urlString;
        }
        return String.valueOf(urlString.substring(0, index - 5)) + Utils.makeAbsolute(urlString.substring(index), rootURL.toExternalForm());
    }
}

