/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIActivator;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIMessages;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.RefreshAction;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUComparator;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.ViewPart;

abstract class ProvView
extends ViewPart {
    TreeViewer viewer;
    private UndoRedoActionGroup undoRedoGroup;
    RefreshAction refreshAction;
    private IPropertyChangeListener preferenceListener;
    protected Display display;

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.viewer = new TreeViewer(parent, 66306);
        this.viewer.getTree().setHeaderVisible(true);
        this.configureViewer(this.viewer);
        this.viewer.setContentProvider(this.getContentProvider());
        this.setTreeColumns(this.viewer.getTree());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.setInput(this.getInput());
        this.addListeners();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProvView.this.fillContextMenu(manager);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)ProvView.this.refreshAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IAction action = ProvView.this.getDoubleClickAction();
                if (action != null && action.isEnabled()) {
                    action.run();
                }
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager manager = bars.getMenuManager();
        this.fillLocalPullDown(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
        this.fillLocalToolBar(bars.getToolBarManager());
        this.undoRedoGroup.fillActionBars(bars);
    }

    protected abstract void fillLocalPullDown(IMenuManager var1);

    protected abstract void fillContextMenu(IMenuManager var1);

    protected abstract void fillLocalToolBar(IToolBarManager var1);

    protected abstract IAction getDoubleClickAction();

    protected void makeActions() {
        this.undoRedoGroup = new UndoRedoActionGroup(this.getSite(), ProvUI.getProvisioningUndoContext(), true);
        this.refreshAction = new RefreshAction((ISelectionProvider)this.viewer, this.viewer.getControl()){

            protected void refresh() {
                ProvView.this.refreshAll();
            }
        };
        this.refreshAction.setToolTipText(ProvAdminUIMessages.ProvView_RefreshCommandTooltip);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.undoRedoGroup != null) {
            this.undoRedoGroup.dispose();
        }
        this.removeListeners();
        super.dispose();
    }

    protected void addListeners() {
        IPreferenceStore store = ProvAdminUIActivator.getDefault().getPreferenceStore();
        this.preferenceListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (ProvView.this.getVisualProperties().contains(event.getProperty())) {
                    ProvView.this.refreshAll();
                }
            }
        };
        store.addPropertyChangeListener(this.preferenceListener);
    }

    protected void removeListeners() {
        if (this.preferenceListener != null) {
            IPreferenceStore store = ProvAdminUIActivator.getDefault().getPreferenceStore();
            store.removePropertyChangeListener(this.preferenceListener);
        }
    }

    Shell getShell() {
        return this.viewer.getControl().getShell();
    }

    Control getViewerControl() {
        return this.viewer.getControl();
    }

    IStructuredSelection getSelection() {
        return (IStructuredSelection)this.viewer.getSelection();
    }

    protected void configureViewer(TreeViewer treeViewer) {
        this.viewer.setComparator((ViewerComparator)new IUComparator(1));
        this.viewer.setComparer((IElementComparer)new ProvElementComparer());
    }

    protected void selectionChanged(IStructuredSelection selection) {
    }

    protected abstract IContentProvider getContentProvider();

    protected Object getInput() {
        return null;
    }

    protected void setTreeColumns(Tree tree) {
        TreeColumn tc = new TreeColumn(tree, 16384, 0);
        tc.setResizable(true);
        tc.setWidth(400);
        tc = new TreeColumn(tree, 16384, 1);
        tc.setWidth(600);
        tc.setResizable(true);
    }

    protected ILabelProvider getLabelProvider() {
        return new ProvElementLabelProvider();
    }

    protected void refreshUnderlyingModel() {
    }

    protected List getVisualProperties() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("org.eclipse.equinox.internal.provisional.p2.ui.admin.showGroupsOnly");
        return list;
    }

    final void refreshAll() {
        this.refreshUnderlyingModel();
        this.viewer.setInput(this.getInput());
    }
}

