/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.query.IUPropertyUtils;
import org.eclipse.osgi.util.NLS;

public class PlanStatusHelper {
    public static IStatus getStatus(int statusCode, IInstallableUnit affectedIU) {
        switch (statusCode) {
            case 10002: {
                return new Status(1, "org.eclipse.equinox.p2.ui", statusCode, NLS.bind((String)ProvUIMessages.PlanStatusHelper_ImpliedUpdate, (Object)PlanStatusHelper.getIUString(affectedIU)), null);
            }
            case 10003: {
                return new Status(2, "org.eclipse.equinox.p2.ui", statusCode, NLS.bind((String)ProvUIMessages.PlanStatusHelper_IgnoringImpliedDowngrade, (Object)PlanStatusHelper.getIUString(affectedIU)), null);
            }
            case 10004: {
                return new Status(2, "org.eclipse.equinox.p2.ui", statusCode, NLS.bind((String)ProvUIMessages.PlanStatusHelper_AlreadyInstalled, (Object)PlanStatusHelper.getIUString(affectedIU)), null);
            }
            case 10005: {
                return new Status(4, "org.eclipse.equinox.p2.ui", statusCode, NLS.bind((String)ProvUIMessages.PlanStatusHelper_NothingToDo, (Object)PlanStatusHelper.getIUString(affectedIU)), null);
            }
            case 10001: {
                return new MultiStatus("org.eclipse.equinox.p2.ui", statusCode, ProvUIMessages.PlanStatusHelper_RequestAltered, null);
            }
        }
        return new Status(4, "org.eclipse.equinox.p2.ui", statusCode, NLS.bind((String)ProvUIMessages.PlanStatusHelper_UnexpectedError, (Object)new Integer(statusCode), (Object)PlanStatusHelper.getIUString(affectedIU)), null);
    }

    public static MultiStatus getProfileChangeAlteredStatus() {
        return (MultiStatus)PlanStatusHelper.getStatus(10001, null);
    }

    public static IStatus computeStatus(ProvisioningPlan plan, IInstallableUnit[] ius) {
        if (plan == null) {
            return PlanStatusHelper.getStatus(10005, null);
        }
        if (plan.getStatus().isOK() || plan.getStatus().getSeverity() == 8) {
            return plan.getStatus();
        }
        if (plan.getStatus().getCode() == 10005) {
            return plan.getStatus();
        }
        if (ius != null && ius.length > 0) {
            boolean iusInPlan = false;
            Operand[] operands = plan.getOperands();
            int i = 0;
            while (i < operands.length) {
                if (operands[i] instanceof InstallableUnitOperand) {
                    iusInPlan = true;
                    break;
                }
                ++i;
            }
            if (!iusInPlan) {
                MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.ui", 10005, ProvUIMessages.PlanStatusHelper_NothingToDo, null);
                status.add(PlanStatusHelper.getStatus(10005, null));
                if (plan.getStatus() != null) {
                    status.merge(plan.getStatus());
                }
                return status;
            }
        }
        return plan.getStatus();
    }

    private static String getIUString(IInstallableUnit iu) {
        if (iu == null) {
            return ProvUIMessages.PlanStatusHelper_Items;
        }
        String name = IUPropertyUtils.getIUProperty(iu, "org.eclipse.equinox.p2.name");
        if (name != null) {
            return name;
        }
        return iu.getId();
    }
}

