/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.viewers;

import org.eclipse.equinox.internal.p2.ui.model.ProvElement;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.repository.IRepository;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IRepositoryElement;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IUElement;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ProvElementLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    static /* synthetic */ Class class$0;

    public String getText(Object obj) {
        if (obj instanceof ProvElement) {
            return ((ProvElement)obj).getLabel(obj);
        }
        if (obj instanceof IProfile) {
            return ((IProfile)obj).getProfileId();
        }
        if (obj instanceof IInstallableUnit) {
            IInstallableUnit iu = (IInstallableUnit)obj;
            return iu.getId();
        }
        if (obj instanceof IRepository) {
            String name = ((IRepository)obj).getName();
            if (name != null && name.length() > 0) {
                return name;
            }
            return ((IRepository)obj).getLocation().toExternalForm();
        }
        if (obj instanceof IRepositoryElement) {
            String name = ((IRepositoryElement)obj).getName();
            if (name != null && name.length() > 0) {
                return name;
            }
            return ((IRepositoryElement)obj).getLocation().toExternalForm();
        }
        if (obj instanceof IArtifactKey) {
            IArtifactKey key = (IArtifactKey)obj;
            return String.valueOf(key.getId()) + " [" + key.getClassifier() + "]";
        }
        if (obj instanceof ProcessingStepDescriptor) {
            ProcessingStepDescriptor descriptor = (ProcessingStepDescriptor)obj;
            return descriptor.getProcessorId();
        }
        if (obj instanceof RequiredCapability) {
            return ((RequiredCapability)obj).getName();
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        if (obj instanceof ProvElement) {
            return ((ProvElement)obj).getImage(obj);
        }
        if (obj instanceof IProfile) {
            return ProvUIImages.getImage("obj/profile_obj.gif");
        }
        if (obj instanceof IInstallableUnit) {
            return ProvUIImages.getImage("obj/uninstalled_iu_obj.gif");
        }
        if (obj instanceof IArtifactRepository) {
            return ProvUIImages.getImage("obj/artifact_repo_obj.gif");
        }
        if (obj instanceof IMetadataRepository) {
            return ProvUIImages.getImage("obj/metadata_repo_obj.gif");
        }
        if (obj instanceof IArtifactKey) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        if (obj instanceof RequiredCapability) {
            return ProvUIImages.getImage("obj/uninstalled_iu_obj.gif");
        }
        return null;
    }

    public Image getColumnImage(Object element, int index) {
        if (index == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getText(element);
            }
            case 1: {
                IInstallableUnit iu;
                if (element instanceof IProfile) {
                    return ((IProfile)element).getProperty("org.eclipse.equinox.p2.name");
                }
                if (element instanceof IUElement && ((IUElement)element).shouldShowVersion()) {
                    return ((IUElement)element).getIU().getVersion().toString();
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iu = (IInstallableUnit)ProvUI.getAdapter(element, clazz)) != null) {
                    return iu.getVersion().toString();
                }
                if (element instanceof IRepository) {
                    return ((IRepository)element).getLocation().toExternalForm();
                }
                if (element instanceof IRepositoryElement) {
                    return ((IRepositoryElement)element).getLocation().toExternalForm();
                }
                if (element instanceof IArtifactKey) {
                    IArtifactKey key = (IArtifactKey)element;
                    return key.getVersion().toString();
                }
                if (!(element instanceof RequiredCapability)) break;
                return ((RequiredCapability)element).getRange().getMaximum().toString();
            }
        }
        return null;
    }
}

