/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GateTranslator
extends SolverDecorator<ISolver> {
    private static final long serialVersionUID = 1L;

    public GateTranslator(ISolver iSolver) {
        super(iSolver);
    }

    public void gateFalse(int n) throws ContradictionException {
        VecInt vecInt = new VecInt(2);
        vecInt.push(-n);
        this.processClause(vecInt);
    }

    public void gateTrue(int n) throws ContradictionException {
        VecInt vecInt = new VecInt(2);
        vecInt.push(n);
        this.processClause(vecInt);
    }

    public void ite(int n, int n2, int n3, int n4) throws ContradictionException {
        VecInt vecInt = new VecInt(5);
        vecInt.push(-n).push(-n2).push(n3);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n).push(n2).push(n4);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n2).push(-n3).push(n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n2).push(-n4).push(n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n3).push(-n4).push(n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n).push(n3).push(n4);
        this.processClause(vecInt);
    }

    public void and(int n, IVecInt iVecInt) throws ContradictionException {
        int n2;
        VecInt vecInt = new VecInt(iVecInt.size() + 2);
        vecInt.push(n);
        for (n2 = 0; n2 < iVecInt.size(); ++n2) {
            vecInt.push(-iVecInt.get(n2));
        }
        this.processClause(vecInt);
        vecInt.clear();
        for (n2 = 0; n2 < iVecInt.size(); ++n2) {
            vecInt.clear();
            vecInt.push(-n);
            vecInt.push(iVecInt.get(n2));
            this.processClause(vecInt);
        }
    }

    public void and(int n, int n2, int n3) throws ContradictionException {
        VecInt vecInt = new VecInt(4);
        vecInt.push(-n);
        vecInt.push(n2);
        this.addClause(vecInt);
        vecInt.clear();
        vecInt.push(-n);
        vecInt.push(n3);
        this.addClause(vecInt);
        vecInt.clear();
        vecInt.push(n);
        vecInt.push(-n2);
        vecInt.push(-n3);
        this.addClause(vecInt);
    }

    public void or(int n, IVecInt iVecInt) throws ContradictionException {
        VecInt vecInt = new VecInt(iVecInt.size() + 2);
        iVecInt.copyTo(vecInt);
        vecInt.push(-n);
        this.processClause(vecInt);
        vecInt.clear();
        for (int i = 0; i < iVecInt.size(); ++i) {
            vecInt.clear();
            vecInt.push(n);
            vecInt.push(-iVecInt.get(i));
            this.processClause(vecInt);
        }
    }

    private void processClause(IVecInt iVecInt) throws ContradictionException {
        this.addClause(iVecInt);
    }

    public void not(int n, int n2) throws ContradictionException {
        VecInt vecInt = new VecInt(3);
        vecInt.push(-n).push(-n2);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n).push(n2);
        this.processClause(vecInt);
    }

    public void xor(int n, IVecInt iVecInt) throws ContradictionException {
        iVecInt.push(-n);
        int[] nArray = new int[iVecInt.size()];
        iVecInt.copyTo(nArray);
        this.xor2Clause(nArray, 0, false);
    }

    public void iff(int n, IVecInt iVecInt) throws ContradictionException {
        iVecInt.push(n);
        int[] nArray = new int[iVecInt.size()];
        iVecInt.copyTo(nArray);
        this.iff2Clause(nArray, 0, false);
    }

    private void xor2Clause(int[] nArray, int n, boolean bl) throws ContradictionException {
        if (n == nArray.length - 1) {
            VecInt vecInt = new VecInt(nArray.length + 1);
            for (int i = 0; i < nArray.length - 1; ++i) {
                vecInt.push(nArray[i]);
            }
            vecInt.push(nArray[nArray.length - 1] * (bl ? -1 : 1));
            this.processClause(vecInt);
            return;
        }
        if (bl) {
            nArray[n] = -nArray[n];
            this.xor2Clause(nArray, n + 1, false);
            nArray[n] = -nArray[n];
            this.xor2Clause(nArray, n + 1, true);
        } else {
            this.xor2Clause(nArray, n + 1, false);
            nArray[n] = -nArray[n];
            this.xor2Clause(nArray, n + 1, true);
            nArray[n] = -nArray[n];
        }
    }

    private void iff2Clause(int[] nArray, int n, boolean bl) throws ContradictionException {
        if (n == nArray.length - 1) {
            VecInt vecInt = new VecInt(nArray.length + 1);
            for (int i = 0; i < nArray.length - 1; ++i) {
                vecInt.push(nArray[i]);
            }
            vecInt.push(nArray[nArray.length - 1] * (bl ? -1 : 1));
            this.processClause(vecInt);
            return;
        }
        if (bl) {
            this.iff2Clause(nArray, n + 1, false);
            nArray[n] = -nArray[n];
            this.iff2Clause(nArray, n + 1, true);
            nArray[n] = -nArray[n];
        } else {
            nArray[n] = -nArray[n];
            this.iff2Clause(nArray, n + 1, false);
            nArray[n] = -nArray[n];
            this.iff2Clause(nArray, n + 1, true);
        }
    }
}

