/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanInfoSupport;

public class ModelMBeanOperationInfo
extends MBeanOperationInfo
implements DescriptorAccess {
    private static final long serialVersionUID = 6532732096650090465L;
    private Descriptor operationDescriptor;

    public ModelMBeanOperationInfo(String description, Method method) {
        this(description, method, null);
    }

    public ModelMBeanOperationInfo(String description, Method method, Descriptor descriptor) {
        super(description, method);
        this.checkAndSetDescriptor(descriptor);
    }

    public ModelMBeanOperationInfo(String name, String description, MBeanParameterInfo[] params, String type, int impact) {
        this(name, description, params, type, impact, null);
    }

    public ModelMBeanOperationInfo(String name, String description, MBeanParameterInfo[] params, String type, int impact, Descriptor descriptor) {
        super(name, description, params, type, impact);
        this.checkAndSetDescriptor(descriptor);
    }

    public ModelMBeanOperationInfo(ModelMBeanOperationInfo copy) {
        super(copy.getName(), copy.getDescription(), copy.getSignature(), copy.getReturnType(), copy.getImpact());
        this.checkAndSetDescriptor(copy.getDescriptor());
    }

    public Object clone() {
        return new ModelMBeanOperationInfo(this);
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.operationDescriptor.clone();
    }

    public void setDescriptor(Descriptor descriptor) {
        if (descriptor == null) {
            this.operationDescriptor = this.createDefaultDescriptor();
        } else if (this.isDescriptorValid(descriptor)) {
            this.operationDescriptor = (Descriptor)descriptor.clone();
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor"));
        }
    }

    private void checkAndSetDescriptor(Descriptor descriptor) {
        if (descriptor == null) {
            this.operationDescriptor = this.createDefaultDescriptor();
        } else if (this.isDescriptorValid(descriptor)) {
            this.operationDescriptor = (Descriptor)descriptor.clone();
            if (this.operationDescriptor.getFieldValue("displayName") == null) {
                this.operationDescriptor.setField("displayName", this.getName());
            }
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid Descriptor"));
        }
    }

    private boolean isDescriptorValid(Descriptor descriptor) {
        if (!descriptor.isValid()) {
            return false;
        }
        String[] names = descriptor.getFieldNames();
        if (!(ModelMBeanInfoSupport.containsIgnoreCase(names, "name") && ModelMBeanInfoSupport.containsIgnoreCase(names, "descriptortype") && ModelMBeanInfoSupport.containsIgnoreCase(names, "role"))) {
            return false;
        }
        String name = this.getName();
        if (name == null) {
            return false;
        }
        if (!name.equals(descriptor.getFieldValue("name"))) {
            return false;
        }
        String desctype = (String)descriptor.getFieldValue("descriptortype");
        if (desctype.compareToIgnoreCase("operation") != 0) {
            return false;
        }
        return "getter".equals(descriptor.getFieldValue("role")) || "setter".equals(descriptor.getFieldValue("role")) || "operation".equals(descriptor.getFieldValue("role"));
    }

    private Descriptor createDefaultDescriptor() {
        String[] names = new String[]{"name", "descriptorType", "role", "displayName"};
        Object[] values = new Object[]{this.getName(), "operation", "operation", this.getName()};
        return new DescriptorSupport(names, values);
    }
}

