/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.common;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.eclipse.equinox.jmx.common.ContributionProxyMBean;
import org.eclipse.equinox.jmx.common.IContributionStateChangeListener;
import org.eclipse.equinox.jmx.common.IContributionStateChangedDispatcher;
import org.eclipse.equinox.jmx.common.util.ByteArrayHolder;

public class ContributionProxy
extends NotificationBroadcasterSupport
implements ContributionProxyMBean,
IContributionStateChangedDispatcher,
Serializable {
    private static final long serialVersionUID = 2259045008283911348L;
    public static final String OP_REFRESH_PROXY = "createProxy";
    public static final String OP_GET_CHILD_CONTRIBUTIONS = "getChildContributions";
    public static final String OP_GET_CONTRIBUTION_UI_URL = "getContributionUIUrl";
    private String name;
    private Set contributionProperties;
    private ObjectName objectName;
    private MBeanInfo info;
    private Set listeners;
    private ByteArrayHolder imageData;

    public ContributionProxy() {
    }

    public ContributionProxy(String name, Set contributionProperties, ByteArrayHolder imageData, ObjectName objectName, MBeanInfo info) {
        this.name = name;
        this.contributionProperties = contributionProperties;
        this.objectName = objectName;
        this.info = info;
        this.imageData = imageData;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getName() {
        return this.name;
    }

    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    public Set getContributionProperties() {
        return this.contributionProperties;
    }

    public ByteArrayHolder getImageData() {
        return this.imageData;
    }

    public ContributionProxy[] getChildContributions(MBeanServerConnection server) throws InstanceNotFoundException, NotCompliantMBeanException, MBeanException, ReflectionException, IOException {
        Object obj = server.invoke(this.getObjectName(), OP_GET_CHILD_CONTRIBUTIONS, null, null);
        if (obj instanceof ContributionProxy[]) {
            return (ContributionProxy[])obj;
        }
        if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            ContributionProxy[] proxies = new ContributionProxy[objs.length];
            int i = 0;
            while (i < objs.length) {
                if (objs[i] instanceof ContributionProxy) {
                    proxies[i] = (ContributionProxy)objs[i];
                }
                ++i;
            }
            return proxies;
        }
        return null;
    }

    public void refresh(MBeanServerConnection server) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        ContributionProxy updatedProxy = (ContributionProxy)server.invoke(this.getObjectName(), OP_REFRESH_PROXY, null, null);
        this.mirror(updatedProxy);
        this.stateChanged();
    }

    public void stateChanged() {
        if (this.listeners == null) {
            return;
        }
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            IContributionStateChangeListener listener = (IContributionStateChangeListener)iter.next();
            listener.stateChanged(this);
        }
    }

    public void addStateChangeListener(IContributionStateChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet(2);
        }
        this.listeners.add(listener);
    }

    public void removeStateChangeListener(IContributionStateChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void update(String name, Set contributionProperties, ByteArrayHolder imageData, ObjectName objectName, MBeanInfo info) {
        this.name = name;
        this.contributionProperties = contributionProperties;
        this.objectName = objectName;
        this.info = info;
        this.imageData = imageData;
    }

    private void mirror(ContributionProxy contribution) {
        this.name = contribution.getName();
        this.contributionProperties = contribution.getContributionProperties();
        this.objectName = contribution.getObjectName();
        this.info = contribution.getMBeanInfo();
    }
}

